//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENIVI_WAYLAND_FRAME_BUFFER_H)
#define GENIVI_WAYLAND_FRAME_BUFFER_H


#include <CanderaPlatform/Device/Common/Internal/GL/GlDefaultFrameBuffer.h>
#include <CanderaPlatform/Device/Genivi/Target/ILM/GeniviSurface.h>

namespace Candera{

/**
 * @brief Extends GlDefaultFrameBuffer in order to do wayland specific
 *        buffer swapping. In Wayland 0.85 wayland needs to get notified
 *        of changed surface content to show it to the screen.
 *        Additionally the display needs to be flushed.
 *        This does only apply to wayland 0.85.
 *        On Wayland versions > 1.0 this is not needed any more.
 */
class GeniviWaylandFrameBuffer : public GlDefaultFrameBuffer<GeniviSurface>
{
    typedef GlDefaultFrameBuffer<GeniviSurface> Base;

public:
    /**
     *  Constructs a GeniviWaylandFrameBuffer object.
     */
    GeniviWaylandFrameBuffer();

    /**
     *  Destructs a GeniviWaylandFrameBuffer object.
     */
    ~GeniviWaylandFrameBuffer();

    /**
     *  Swaps the buffers of the associated EGLSurface.
     *  @param contextProvider  parameter which provides the surface and the display.
     */
    CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1511, CANDERA_LINT_REASON_EXPLICITHIDING)
    void SwapBuffers(EglChain& contextProvider);

};

}

#endif
