//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GeniviWaylandFrameBuffer.h"
#include <GeniviDevicePackageDescriptor.h>
#include <GeniviWindowSurfaceRenderTarget.h>

namespace Candera{

GeniviWaylandFrameBuffer::GeniviWaylandFrameBuffer():
    Base()
{
}


GeniviWaylandFrameBuffer::~GeniviWaylandFrameBuffer()
{
}

namespace Internal {
class RenderTargetBaseWrapper : public  GeniviWindowSurfaceRenderTargetNameSpace::RenderTargetBase
{
public:
    typedef  GeniviWindowSurfaceRenderTargetNameSpace::RenderTargetBase Base;

    void AfterSwapBuffersExecuted(){
        Base::template Base::NotifyListenersOnAfterSwapBuffersExecuted();

    }

    void BeforeSwapBuffersCalled(){
        Base::template Base::NotifyListenersOnBeforeSwapBuffersCalled();
    }
};
}

void GeniviWaylandFrameBuffer::SwapBuffers(EglChain& contextProvider)
{
    Internal::RenderTargetBaseWrapper& wrapper = static_cast<Internal::RenderTargetBaseWrapper&>(contextProvider);
    wrapper.BeforeSwapBuffersCalled();
    Base::SwapBuffers(contextProvider);
    wrapper.AfterSwapBuffersExecuted();
}

}
