//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENIVI_WINDOW_SURFACE_H)
#define GENIVI_WINDOW_SURFACE_H

#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnit.h>
#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnitMetaInfo.h>

#include <CanderaPlatform/Device/Common/Internal/GDU/GduAttachment.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduWrapperExposer.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduWrapperRenderTarget2D.h>
#include <CanderaPlatform/Device/Common/Internal/EGL/EglAntiAliasedWindowSurfaceProperties.h>

#include <CanderaPlatform/Device/Genivi/GeniviDevicePackageDescriptor.h>
#include <GeniviWindowSurfaceRenderTarget.h>
#include <GeniviSurface.h>
#include <CanderaPlatform/Device/Genivi/GeniviSurfaceProperties.h>

namespace Candera
{

namespace GeniviWindowSurfaceNameSpace
{
    typedef GduBase <
        GeniviWindowSurfaceRenderTarget,
        EglAntiAliasedWindowSurfaceProperties,
        GeniviSurface,
        GeniviSurfaceProperties,
        c_geniviWindowSurfaceType>
            SimpleBase;

    typedef GduAttachment <
        SimpleBase,
        GduWrapperExposer<GeniviWindowSurfaceRenderTarget, RenderTarget3D>,
        GduProperties>
            Base3D;

#ifdef CANDERA_2D_ENABLED
    typedef GduAttachment <
        Base3D,
        GduWrapperRenderTarget2D<GeniviWindowSurfaceRenderTarget>,
        GduProperties>
        Base;
#else
    FEATSTD_TYPEDEF_BASE(Base3D);
#endif //CANDERA_2D_ENABLED
};

/** @addtogroup GeniviGDI
 *  @{
 */
 
/**
 * @brief The class GeniviWindowSurface represents a 3D window surface (frame buffer) on the "Genivi" platform.
 *
 * It can be used as a 3D render target. It is the representative on Genivi of the DisplayTarget3D category.
 *
 * Supported properties:
 * - Candera::GeniviSurfaceProperties (use GetSupportProperties() on Candera::GeniviWindowSurface)
 * - Candera::EglAntiAliasedWindowSurfaceProperties (use GetProperties() on Candera::GeniviWindowSurface)
 */
class GeniviWindowSurface : public GeniviWindowSurfaceNameSpace::Base
{
    public:
        GeniviWindowSurface() {
#ifdef GENIVI_DEFAULT_TARGET_SWAP_INTERVAL
            GetProperties().SetSwapInterval(GENIVI_DEFAULT_TARGET_SWAP_INTERVAL);
#endif //GENIVI_DEFAULT_TARGET_SWAP_INTERVAL
        }

        /// @cond excluded from doxygen
        CdaGduDef(GeniviWindowSurface)
            CdaReadableName("Hybrid 2D/3D Window Surface")
            CdaDescription("This render target represents an on-screen window surface. "
                           "Both 2D and 3D cameras can be linked to this render target type. ")

            CdaGduProperties()

            CdaGduImportProperties(GeniviSurfaceProperties, Candera::GeniviSurfaceProperties, GetSupportProperties())
            CdaGduImportProperties(EglAntiAliasedWindowSurfaceProperties, Candera::EglAntiAliasedWindowSurfaceProperties, GetProperties())

            CdaGduPropertiesEnd()
        CdaGduDefEnd()
        /// @endcond

    private:

        // Disallow copies of GeniviWindowSurface objects.
        CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::GeniviWindowSurface::GeniviWindowSurface, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
        GeniviWindowSurface(const GeniviWindowSurface& /*rhs*/);
        GeniviWindowSurface& operator=(const GeniviWindowSurface& /*rhs*/);

};

/** @}*/ //end of GeniviGDI

}

#endif
