//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENIVI_GPU_PERFORMANCE_DATA_H)
#define GENIVI_GPU_PERFORMANCE_DATA_H

#include <CanderaPlatform/Device/Common/Base/DevicePackageInterface.h>
#include <CanderaPlatform/Device/Common/Base/GpuPerformanceDataProvider.h>

namespace Candera {

class GeniviGpuPerformanceDataProvider : public GpuPerformanceDataProvider {
    friend GpuPerformanceDataProvider* DevicePackageInterface::GetGpuPerformanceDataProvider();

public:
    virtual bool GetPerformanceData(GpuPerformanceData& performanceData);

private:
    GeniviGpuPerformanceDataProvider() :
       m_wasOk(false),
       m_lastUpdate(0)
    {
        Candera::MemoryPlatform::Set(&m_cached, 0, sizeof(m_cached));
    }
    bool m_wasOk;
    UInt32 m_lastUpdate;
    GpuPerformanceData m_cached;
};

}

#endif // !defined(GENIVI_GPU_PERFORMANCE_DATA_H)
