//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENIVI_FRAMEBUFFER_PROPERTIES_H)
#define GENIVI_FRAMEBUFFER_PROPERTIES_H

#include <CanderaPlatform/Device/Common/Base/RenderTarget3D.h>
#include <CanderaPlatform/Device/Common/OpenGLES/GlOwnedFrameBufferProperties.h>

namespace Candera
{
namespace Internal {
/**
 * @brief Class for defining an editor string for the owning render target.
 */
class GeniviOwnerEditorForFrameBufferProperties
{
public:
    static const Char* GetEditor() 
    {
        return "builtin://RenderTargetEditor?CanderaTypeName="
            "GeniviWindowSurface";
    }
};
}

typedef GlOwnedFrameBufferProperties<
    RenderTarget3D,
    Internal::GeniviOwnerEditorForFrameBufferProperties>
        GeniviFrameBufferProperties;

}

#endif
