//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENIVI_COMMON_DEVICE_PACKAGE_INTERFACE_H)
#define GENIVI_COMMON_DEVICE_PACKAGE_INTERFACE_H

#include <Candera/Environment.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageInterface.h>
#include <CanderaPlatform/Device/Common/Base/DeviceMetaInfo.h>


namespace Candera
{

class GeniviDisplay;
class DevicePackageDescriptor;

/** @addtogroup GeniviGDI
 *  @{
 */

/**
 * @brief The class GeniviDevicePackageInterface represents the entry point for common Display handling.
 */
class GeniviDevicePackageInterface : public DeviceMetaInfoHost
{
    friend class DevicePackageDescriptor;

    public:
        /**
         * Retrieves instance of GeniviDevicePackageInterface.
         * @return GeniviDevicePackageInterface object.
         */
        static GeniviDevicePackageInterface& GetInstance();

        /**
         * Retrieves GeniviDisplay object for the display id given.
         * @param displayId specifies the identifier for the targets display, reaching from 0 to MaxDisplayCount - 1.
         * @return pointer to GeniviDisplay object if already created, null pointer otherwise.
         */
        GeniviDisplay* GetDisplay(Int displayId) const;

        /**
         * Creates GeniviDisplay object for display ID given.
         * @param displayId specifies the identifier for the targets display, reaching from 0 to MaxDisplayCount - 1.
         * @return true if display has been created successfully, false otherwise.
         */
        bool CreateDisplay(Int displayId);

        /**
         * Destructs GeniviDisplay object for display ID given.
         * @param displayId specifies the identifier for the targets display, reaching from 0 to MaxDisplayCount - 1.
         */
        void DestroyDisplay(Int displayId);

        /**
         * Apply the current properties set via meta-info interface to the device.
         * Implements virtual method from DeviceMetaInfoHost.
         */
        virtual void ApplyChanges();

        CdaDeviceMetaInfoHostDef(GeniviDevicePackageInterface)
            CdaDescription("Genivi Device Package configuration interface")

            CdaDeviceMetaInfoHostProperties()
            CdaDeviceMetaInfoHostPropertiesEnd()

        CdaDeviceMetaInfoHostDefEnd()

    private:
        enum { MaxDisplayCount = 4 };                   ///< 4 display support (Subject to be changed)
        GeniviDisplay* m_displays[MaxDisplayCount];     ///< Array to map display IDs to GeniviDisplay objects.

        // implemented as singleton
        GeniviDevicePackageInterface();
        ~GeniviDevicePackageInterface();
};

/** @}*/ //end of GeniviGDI

}


#endif //GENIVI_COMMON_DEVICE_PACKAGE_INTERFACE_H
