//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GeniviDevicePackageDescriptor.h"
#include <CanderaPlatform/Device/Genivi/GeniviCommonDevicePackageInterface.h>
#include <CanderaPlatform/Device/Genivi/GeniviDisplay.h>

#include <CanderaPlatform/Device/Genivi/GeniviWindowSurface.h>
#include <CanderaPlatform/Device/Genivi/GeniviFrameBufferObject.h>

namespace Candera
{

const Char* DevicePackageDescriptor::GetGraphicPackageName()
{
    return "Genivi";
}

const GraphicDeviceUnitTypeHandle* DevicePackageDescriptor::GetUnitTypes(UnitCategory category, Int display, Int& count)
{
    if ((display < 0) || (display >= GetNumberOfDisplays())) {
        count = 0;
        return 0;
    }

    switch (category) {
        FEATSTD_LINT_CURRENT_SCOPE(1960, "false positive - the case statements return terminates every group of case statements")

        case DisplayTarget3D:
#ifdef CANDERA_2D_ENABLED
        case DisplayTarget2D:
        case Mixed2D3DDisplayTarget:
#endif //CANDERA_2D_ENABLED
            count = 1;
            return &c_geniviWindowSurfaceType;

        case OffscreenTarget3D:
#ifdef CANDERA_2D_ENABLED
        case OffscreenTarget2D:
        case Mixed2D3DOffscreenTarget:
#endif //CANDERA_2D_ENABLED
            count = 1;
            return &c_geniviFrameBufferObjectType;

        default:
            count = 0;
            return 0;
    }
}

const Char* DevicePackageDescriptor::GetGraphicPackageShaderCompiler()
{
    return "builtin://DefaultShaderCompiler";
}

DevicePackageDescriptor::UnitCategory DevicePackageDescriptor::GetUnitCategory(GraphicDeviceUnitTypeHandle unitType){
    switch (unitType) {
        FEATSTD_LINT_CURRENT_SCOPE(1960, "false positive - the case statements return terminates every group of case statements")

        case c_geniviWindowSurfaceType:
#ifdef CANDERA_2D_ENABLED
            return Mixed2D3DDisplayTarget;
#else //ndef CANDERA_2D_ENABLED
            return DisplayTarget3D;
#endif //CANDERA_2D_ENABLED
        case c_geniviFrameBufferObjectType:
#ifdef CANDERA_2D_ENABLED
            return Mixed2D3DOffscreenTarget;
#else //ndef CANDERA_2D_ENABLED
            return OffscreenTarget3D;
#endif //CANDERA_2D_ENABLED

        default:
            return ExternalSource;
    }
}

const Candera::MetaInfo::GraphicDeviceUnitMetaInfo* DevicePackageDescriptor::GetMetaInformation(GraphicDeviceUnitTypeHandle objectType)
{
    static GeniviWindowSurface::MetaInfo          geniviWindowSurfaceMetaInfo;
    static GeniviFrameBufferObject::MetaInfo      geniviFrameBufferObjectMetaInfo;

    switch (objectType) {
        FEATSTD_LINT_CURRENT_SCOPE(1960, "false positive - the case statements return terminates every group of case statements")

        case c_geniviWindowSurfaceType:
            return &geniviWindowSurfaceMetaInfo;
        case c_geniviFrameBufferObjectType:
            return &geniviFrameBufferObjectMetaInfo;
        default:
            return 0;
    }
}

const Char* DevicePackageDescriptor::GetAvailableFractionalNumberFormats()
{
    return "float";
}

Int DevicePackageDescriptor::GetNumberOfDisplays()
{
    return  GeniviDevicePackageInterface::MaxDisplayCount;
}

const Candera::MetaInfo::DeviceMetaInfo* DevicePackageDescriptor::GetDisplayMetaInformation(Int /*displayId*/)
{
    return 0;
}

Int DevicePackageDescriptor::GetDisplayContextResourcePoolIndex(Int /*displayId*/)
{
    return -1;
}

const Candera::MetaInfo::DeviceMetaInfo* DevicePackageDescriptor::GetPackageMetaInformation()
{
    static GeniviDevicePackageInterface::MetaInfo devicePackageMetaInfo;
    return &devicePackageMetaInfo;
}

Candera::DeviceMetaInfoHost* DevicePackageDescriptor::GetMetaInformationHost()
{
    return &GeniviDevicePackageInterface::GetInstance();
}


const PlatformDescription& DevicePackageDescriptor::GetPlatformDescription()
{
    static PlatformDescription plf = {
#ifdef CANDERA_2D_ENABLED
        true,  // bool is2DSupported;               ///<    Defines whether the platform supports 2D rendering or not.
#else
        false,
#endif
#ifdef CANDERA_3D_ENABLED
        true,   // bool is3DSupported;               ///<    Defines whether the platform supports 3D rendering or not.
#else
        false,
#endif
        false,  // bool is2DBitmapVerticallyFlipped; ///<    Defines if 2D Bitmaps are vertically flipped (lower left corner has coordinates 0/0) of not (upper left corner has coordinates 0/0).
        true,   // bool is3DBitmapVerticallyFlipped; ///<    Defines if 3D Bitmaps are vertically flipped (lower left corner has coordinates 0/0) of not (upper left corner has coordinates 0/0).
        true,   // bool isWindowManagerUsed;         ///<    Defines whether the platform uses a Window Manager.
    };

    return plf;
}

bool DevicePackageDescriptor::GetRenderDevice3DCapabilities(DisplayAdapter displayAdapter, DeviceType deviceType, const RenderDevice3DCapabilities*& capabilities)
{
    //To be updated with real target capabilities.
    bool result = true;

    switch (displayAdapter) {
        case DefaultAdapter: {
            switch (deviceType) {
                case TargetDevice: {
                    static const RenderDevice3DCapabilities caps = {
                        8192,           // UInt32 m_maxTextureSize;
                        8,              // UInt8 m_maxCombinedTextureImageUnits;
                        4096,           // UInt32 m_maxCubeMapTextureSize;
                        512,            // UInt16 m_maxFragmentUniformVectors;
                        4096,           // UInt32 m_maxRenderbufferSize;
                        8,              // UInt8 m_maxTextureImageUnits;
                        8,              // UInt8 m_maxVaryingVectors;
                        64,             // UInt8 m_maxVertexAttribs;
                        8,              // UInt8 m_maxVertexTextureImageUnits;
                        512,            // UInt16 m_maxVertexUniformVectors;
                        {3840, 3840},   // ViewportDims m_maxViewportDims;
                        0xFFFFFF,       // UInt32 m_maxElementIndex;
                        "OpenGL ES 2.0",// const Char* m_rendererAPI;
                        true            // m_isDxtCompressionSupported;
                    };

                    capabilities = &caps;
                    break;
                }
                case SimulationDevice: {
                    static const RenderDevice3DCapabilities* caps;
                    result = GetCurrentRenderDevice3DCapabilities(caps);
                    capabilities = caps;
                    break;
                }
                default: {
                    result = false;
                }
            }
            break;
        }
        default: {
            result = false;
            break;
        }
    }

    return result;
}

}
