//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_GlTraceMapper_h
#define Candera_GlTraceMapper_h

#include <Candera/Environment.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageTrace.h>
#include <CanderaPlatform/Device/Common/OpenGLES/GlInclude.h>

namespace Candera {

    /**
     * @brief   The GlTraceMapper is a helper class used by different devices to map GlError types to Strings.
     *          The implementation of this class resides in the OpenGL ES version specific package.
     */
    class GlTraceMapper
    {
    public:
        /**
         *  A GlError type is mapped to a String.
         *  @param glErrorType The Gl type that is mapped.
         *  @return The mapped string.
         */
        static const Char* MapGlErrorToString(GLenum glErrorType);
    };

#ifdef FEATSTD_GLERRORS_AND_EGLERRORS_ENABLED
    // Logging Enabled

#define CANDERA_GL_CHECK_ERROR_LOG_ERROR(text) \
    { \
    const UInt glError = static_cast<UInt>(glGetError()); \
    if (GL_NO_ERROR != glError) { \
        FEATSTD_LOG_ERROR("Text: %s Error: %s.",text, GlTraceMapper::MapGlErrorToString(glError)); \
        return false; \
        } \
    }

#define CANDERA_GL_CHECK_ERROR_LOG_INFO(text) \
    { \
    const UInt glError = static_cast<UInt>(glGetError()); \
    if (GL_NO_ERROR != glError) { \
        FEATSTD_LOG_INFO("Text: %s Error: %s.",text, GlTraceMapper::MapGlErrorToString(glError)); \
        return false; \
        } \
    }

#define CANDERA_GL_CHECK_ERROR_NO_RETURN(text) \
    { \
    const UInt glError = static_cast<UInt>(glGetError()); \
    if (GL_NO_ERROR != glError) { \
        FEATSTD_LOG_ERROR("Text: %s Error: %s.",text, GlTraceMapper::MapGlErrorToString(glError)); \
        } \
    }

#define CANDERA_GL_CHECK_ERROR_CONDITION(condition, text) \
    { \
    if (!(condition)) { \
        const UInt glError = static_cast<UInt>(glGetError()); \
        if (GL_NO_ERROR != glError) { \
            FEATSTD_LOG_ERROR("Text: %s Error: %s.",text, GlTraceMapper::MapGlErrorToString(glError)); \
            return false; \
                } \
        } \
    }

#else
// Release build.
#define CANDERA_GL_CHECK_ERROR_LOG_ERROR(text)
#define CANDERA_GL_CHECK_ERROR_LOG_INFO(text)
#define CANDERA_GL_CHECK_ERROR_NO_RETURN(text)
#define CANDERA_GL_CHECK_ERROR_CONDITION(condition, text)

#endif
 
} // namespace Candera

#endif// Candera_GlTraceMapper_h
