//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlTraceMapper.h"

namespace Candera {
    
    const Char* GlTraceMapper::MapGlErrorToString(GLenum glErrorType) {
        const Char* ret;
        switch(glErrorType) {
            case GL_NO_ERROR:                         ret = "GL_NO_ERROR"; break;
            case GL_INVALID_ENUM:                     ret = "GL_INVALID_ENUM"; break;
            case GL_INVALID_VALUE:                    ret = "GL_INVALID_VALUE"; break;
            case GL_INVALID_OPERATION:                ret = "GL_INVALID_OPERATION"; break;
            case GL_INVALID_FRAMEBUFFER_OPERATION:    ret = "GL_INVALID_FRAMEBUFFER_OPERATION"; break;
            case GL_OUT_OF_MEMORY:                    ret = "GL_OUT_OF_MEMORY"; break;
            default:                                  ret = "UNKNOWN_GL_ERROR"; break;
        }

        return ret;
    }
}
