//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GL_OWNED_FRAME_BUFFER_PROPERTIES_H)
#define GL_OWNED_FRAME_BUFFER_PROPERTIES_H

#include <CanderaPlatform/Device/Common/OpenGLES/GlFrameBufferProperties.h>


namespace Candera
{

    class RenderTarget3D;

/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief GlOwnedFrameBufferProperties adds an owner to GlFrameBufferProperties.
 */
template<
    typename TOwner, 
    typename TEditorProvider = MetaInfo::DataType<TOwner*> >
class GlOwnedFrameBufferProperties : public GlFrameBufferProperties
{
    public:
        typedef TOwner Owner;
        typedef TEditorProvider EditorProvider;
        typedef GlOwnedFrameBufferProperties<Owner, EditorProvider> This;

        /**
         * Constructs a GlFrameBufferProperties object.
         */
        GlOwnedFrameBufferProperties();
        GlOwnedFrameBufferProperties(const GlFrameBufferProperties& base);

        /**
         * Set the owner of the surface.
         * @param owner 
         */
        void SetOwner(Owner* owner) { m_owner = owner; }
        
        /**
         * Get the owner of the surface.
         */
         Owner* GetOwner() const { return m_owner; }

        /// @cond excluded from doxygen
        CdaForeignGduDef(This)
            CdaGduProperties()

                CdaGduImportBaseClassProperties(GlFrameBufferProperties, GlFrameBufferProperties)

                CdaGduProperty(Owner, Owner*, GetOwner, SetOwner)
                    CdaDescription("Owner of the surface.")
                    CdaEditor(EditorProvider::GetEditor())
                CdaGduPropertyEnd()

            CdaGduPropertiesEnd()
        CdaGduDefEnd()
        /// @endcond

    private:
        Owner* m_owner;
};

/** @}*/ //end of CommonDevice


template<typename TOwner, typename TEditorProvider>
GlOwnedFrameBufferProperties<TOwner, TEditorProvider>::GlOwnedFrameBufferProperties() :
    m_owner(0)
{
}

template<typename TOwner, typename TEditorProvider>
GlOwnedFrameBufferProperties<TOwner, TEditorProvider>::GlOwnedFrameBufferProperties(const GlFrameBufferProperties& base) :
    GlFrameBufferProperties(base),
    m_owner(0)
{
}

}

#endif //def GL_OWNED_FRAME_BUFFER_PROPERTIES_H
