//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLINCLUDE_H)
#define CANDERA_GLINCLUDE_H

#if defined(CGIDEVICE_OPENGLES_30)
#include <CONFIG/gl3config.h>
#include <GLES3/gl3.h>
#include <GLES2/gl2ext.h>
#include <GLES3/gl3ext.h>
#define CANDERA_DEVICE_EGL_CONTEXT_CLIENT_VERSION 3
#define CANDERA_GLES_VERSION 30
#elif defined(CGIDEVICE_OPENGLES_11)
#include <CONFIG/glconfig.h>
#include <GLES/gl.h>
#include <GLES/glext.h>
#define CANDERA_DEVICE_EGL_CONTEXT_CLIENT_VERSION 1
#define CANDERA_GLES_VERSION 11
#define GL_INVALID_FRAMEBUFFER_OPERATION          0x0506
#else
#include <CONFIG/gl2config.h>
#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>
#define CANDERA_DEVICE_EGL_CONTEXT_CLIENT_VERSION 2
#define CANDERA_GLES_VERSION 20
#endif

#define CANDERA_GLES_INCLUDE(file) <CanderaPlatform/Device/Common/FEATSTD_CONCAT2(OpenGLES,CANDERA_GLES_VERSION)/file>

// Specifies an invalid parameter for render device, used for not supported Open GL ES extension tokens.
static const GLenum c_glInvalidParameter = 0xFFffFFff;

#endif// CANDERA_EGLINCLUDE_H
