//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GL_FRAME_BUFFER_FORMAT_PROPERTIES_H)
#define GL_FRAME_BUFFER_FORMAT_PROPERTIES_H

#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnitMetaInfo.h>

#include <CanderaPlatform/Device/Common/Internal/GDU/GduProperties.h>
#include <CanderaPlatform/Device/Common/Internal/GL/GlFrameBufferTypes.h>

#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderBaseDataTypes.h>

namespace Candera
{
/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief GlFrameBufferFormatProperties is a class holding the pixel format information
 * needed for initializing a GlTextureFrameBuffer.
 */

class GlFrameBufferFormatProperties : public GduProperties
{
    public:
        /**
         * Constructs a GlFrameBufferFormatProperties object.
         */
        GlFrameBufferFormatProperties();

        // Properties
        void SetColorFormat(FrameBufferColorFormat value) { m_colorFormat = value; }
        FrameBufferColorFormat GetColorFormat() const { return m_colorFormat; }

        Int GetBitmapPixelFormat() const { return FrameBufferColorFormatToBitmapPixelFormat(m_colorFormat); }

        void SetDepthFormat(FrameBufferDepthFormat value) { m_depthFormat = value; }
        FrameBufferDepthFormat GetDepthFormat() const { return m_depthFormat; }

        void SetStencilFormat(FrameBufferStencilFormat value) { m_stencilFormat = value; }
        FrameBufferStencilFormat GetStencilFormat() const { return m_stencilFormat; }

        void SetExternalColorTexture(ImageSource3D* value) { m_colorExtension = value; }
        ImageSource3D* GetExternalColorTexture() const { return m_colorExtension; }

        void SetExternalDepthBuffer(ImageSource3D* value) { m_depthExtension = value; }
        ImageSource3D* GetExternalDepthBuffer() const { return m_depthExtension; }

        void SetExternalStencilBuffer(ImageSource3D* value) { m_stencilExtension = value; }
        ImageSource3D* GetExternalStencilBuffer() const { return m_stencilExtension; }
        
        /// @cond excluded from doxygen
        CdaForeignGduDef(GlFrameBufferFormatProperties)
            CdaGduProperties()

                CdaGduProperty(ColorFormat, FrameBufferColorFormat, GetColorFormat, SetColorFormat)
                    CdaDescription("Color buffer format")
                CdaGduPropertyEnd()

                CdaGduProperty(DepthFormat, FrameBufferDepthFormat, GetDepthFormat, SetDepthFormat)
                    CdaDescription("Depth buffer format")
                CdaGduPropertyEnd()

                CdaGduProperty(StencilFormat, FrameBufferStencilFormat, GetStencilFormat, SetStencilFormat)
                    CdaDescription("Stencil buffer format")
                CdaGduPropertyEnd()

                CdaGduProperty(ExternalColorTexture, ImageSource3D*, GetExternalColorTexture, SetExternalColorTexture)
                    CdaDescription("Attach external color buffer. The format must describe the color buffer as best as posible.")
                CdaGduPropertyEnd()

                CdaGduProperty(ExternalDepthBuffer, ImageSource3D*, GetExternalDepthBuffer, SetExternalDepthBuffer)
                    CdaDescription("Attach external depth buffer. The format must describe the depth buffer as best as posible.")
                CdaGduPropertyEnd()

                CdaGduProperty(ExternalStencilBuffer, ImageSource3D*, GetExternalStencilBuffer, SetExternalStencilBuffer)
                    CdaDescription("Attach external stencil buffer. The format must describe the stencil buffer as best as posible.")
                CdaGduPropertyEnd()

            CdaGduPropertiesEnd()
        CdaGduDefEnd()
        /// @endcond

    private:
        FrameBufferColorFormat m_colorFormat;
        FrameBufferDepthFormat m_depthFormat;
        FrameBufferStencilFormat m_stencilFormat;

        ImageSource3D* m_colorExtension;
        ImageSource3D* m_depthExtension;
        ImageSource3D* m_stencilExtension;
};

/** @}*/ //end of CommonDevice
}

#endif //def GL_FRAME_BUFFER_FORMAT_PROPERTIES_H
