//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_UTIL_SELECT_H)
#define CANDERAPLATFORM_UTIL_SELECT_H

namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */

namespace Util {

    template <typename First, typename Second, typename Selector>
    class Select {};

    template <typename First, typename Second>
    class Select<First, Second, First>
    {
    public:
        typedef First Type;
        static Type& Get(First& first, Second& /*second*/) { return first; }
        static const Type& Get(const First& first, const Second& /*second*/) { return first; }
    };

    template <typename First, typename Second>
    class Select<First, Second, Second>
    {
    public:
        typedef Second Type;
        static Type& Get(First& /*first*/, Second& second) { return second; }
        static const Type& Get(const First& /*first*/, const Second& second) { return second; }
    };

}

/** @}*/ //end of CommonDevice

}

#endif //CANDERAPLATFORM_UTIL_SELECT_H

