//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SurfaceAllocator_H)
#define CANDERA_SurfaceAllocator_H

#include <Candera/Environment.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>
#include <CanderaPlatform/Device/Common/Internal/AllocatorBase.h>

namespace Candera {
    /**
     * @brief SurfaceAllocator is a helper class intended to handle generic tasks involved in
     * surface allocation.
     *
     * @param TInfo Defines the platform specific type of the stored surface data.
     **/
    template<typename TInfo>
    class SurfaceAllocator : public AllocatorBase<TInfo, SurfaceHandle>
    {
        FEATSTD_LINT_SYMBOL(1516, *(AllocatorBase<TInfo, SurfaceHandle>), "Typedef to Base is used in a derived class to access its base class by standard term.");
        typedef AllocatorBase<TInfo, SurfaceHandle> Base;

    public:

        virtual ~SurfaceAllocator() override
        {
        }

        bool CreateSurfaces(Int count, SurfaceHandle *pSurface)
        {
            return Base::CreateItems(count, pSurface);
        }

        bool DestroySurfaces(Int count, SurfaceHandle *pSurface)
        {
            return Base::DestroyItems(count, pSurface);
        }

        static TInfo* GetDataFromSurfaceHandle(SurfaceHandle surface)
        {
            return Base::GetDataFromItemHandle(surface);
        }
    };
} // namespace Candera
#endif //CANDERA_SurfaceAllocator_H
