//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "SurfaceAllocator2DOver3D.h"
#include <FeatStd/Util/StaticObject.h>

namespace Candera {
    namespace Internal {

        static SurfaceAllocator2DOver3D& s_forceInit = SurfaceAllocator2DOver3D::GetInstance();

SurfaceAllocator2DOver3D& SurfaceAllocator2DOver3D::GetInstance()
{
    FEATSTD_UNSYNCED_STATIC_OBJECT(SurfaceAllocator2DOver3D, s_instance);
    return s_instance;
}

SurfaceAllocator2DOver3D::TextureImagePointer SurfaceAllocator2DOver3D::GetTextureImage(SurfaceHandle surface)
{
    SurfaceInfo* surfaceInfo = SurfaceAllocator2DOver3D::GetInstance().GetBase().GetDataFromSurfaceHandle(surface);
    if (surfaceInfo != 0){
        return surfaceInfo->textureImage;
    }
    return TextureImagePointer();
}

bool SurfaceAllocator2DOver3D::HasTextureImage(SurfaceHandle surface)
{
    SurfaceInfo* surfaceInfo = SurfaceAllocator2DOver3D::GetInstance().GetBase().GetDataFromSurfaceHandle(surface);
    return (surfaceInfo != 0) && (!surfaceInfo->textureImage.PointsToNull());
}

SurfaceAllocator2DOver3D::SurfaceInfo::SurfaceInfo():
    packOrder(RenderDevice2D::UnknownPackOrder),
    pixelFormat(0)
{
}

bool SurfaceAllocator2DOver3D::SurfaceInfo::Clear()
{
    bool success = true;
    if (textureImage != 0) {
        success = textureImage->Unload(DeviceObject::ForceAll);
        textureImage.Release();
    }

    packOrder = RenderDevice2D::UnknownPackOrder;
    pixelFormat = 0;

    return success;
}

}}
