//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_RENDERDEVICE2DOVER3D_H
#define CANDERA_RENDERDEVICE2DOVER3D_H

#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>

namespace Candera {

    class Color;
    class Vector2;

    namespace Internal {
        class RenderDevice2DOver3D
        {
        public:
            /**
             * Set the color used for the gradient effects, along with the source surface const color.
             * @param context 2D context obtained from RenderTarget2D.
             * @param color Color used for the gradient effect.
             * @return          true on success, false on failure.
             */
            static bool SetGradientColor(ContextHandle2D context, const Color& color);

            /**
             * Set the direction used for the linear gradient effect.
             * @param context 2D context obtained from RenderTarget2D.
             * @param direction direction of the gradient effect.
             * @return          true on success, false on failure.
             */
            static bool SetGradientDirection(ContextHandle2D context, const Vector2& direction);

            /**
             * Set the center of the gradient effects.
             * @param context 2D context obtained from RenderTarget2D.
             * @param center center of the gradient effects.
             * @return          true on success, false on failure.
             */
            static bool SetGradientCenter(ContextHandle2D context, const Vector2& center);

            /**
             * Set the magnitude of the gradient effects.
             * @param context 2D context obtained from RenderTarget2D.
             * @param magnitude magnitude of the gradient effects.
             * @return          true on success, false on failure.
             */
            static bool SetGradientMagnitude(ContextHandle2D context, Float magnitude);

             /**
             * Set horizontal, vertical or both horizontal and vertical flipping.
             * @param context 2D context obtained from RenderTarget2D.
             * @param flipH true if horizontal flipping is enabled, false otherwise.
             * @param flipV true if vertical flipping is enabled, false otherwise.
             * @return      true on success, false on failure.
             */
            static bool SetFlipMode(ContextHandle2D context, bool flipH, bool flipV);

            /**
             * Set outline parameters   
             * @param context 2D context obtained from RenderTarget2D.
             * @param filterSize width of the outline
             * @param filteredColor color of the outline
             * @param pixelDimensions size of a pixel of the source surface in texture coordinate system (0/0) to (1/1)
             * @return      true on success, false on failure.                                                                  
            */
            static bool SetOutlineParameters(ContextHandle2D context, UInt8 outlineWidth, Color outlineColor, Int colorFactor);

            /**
            * Set dropshadow parameters.
             * @param context 2D context obtained from RenderTarget2D.
             * @param enabled whether dropshodw effect is applied or not.
             * @param shadowColor color of the shadow.
             * @param angle angle of virtal light the casts the shadow.
             * @param distance distance of the shadow from the source.
             * @param scale size of the shadow in pixels.
             * @param blurFilter whether blurring is applied to the shadow or not.
             * @return      true on success, false on failure.                                                  
            */
            static bool SetDropShadowParameters(ContextHandle2D context, bool enabled, Color shadowColor, Int angle, Int distance, Int scale, Int colorFactor, bool blurFilter);
        };
    }
}

#endif //CANDERA_RENDERDEVICE2DOVER3D_H
