//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlRadialGradientBrushBlend.h"
#include <Candera/System/Monitor/PerfMonPublicIF.h>

namespace Candera {
    FEATSTD_RTTI_DEFINITION(GlRadialGradientBrushBlend, CombinedEffect2D)

    /******************************************************************************
     *  Constructor
     ******************************************************************************/
    GlRadialGradientBrushBlend::GlRadialGradientBrushBlend()
    {
    }

    GlRadialGradientBrushBlend::GlRadialGradientBrushBlend(const GlRadialGradientBrushBlend& rhs) :
        Base(rhs),
        m_gradientBrush(rhs.m_gradientBrush),
        m_blendEffect(rhs.m_blendEffect)
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    GlRadialGradientBrushBlend::~GlRadialGradientBrushBlend()
    {
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    GlRadialGradientBrushBlend::SharedPointer GlRadialGradientBrushBlend::Create()
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

        GlRadialGradientBrushBlend* brush = FEATSTD_NEW(GlRadialGradientBrushBlend);
        FEATSTD_DEBUG_ASSERT(brush != 0);

        GlRadialGradientBrushBlend::SharedPointer sharedPtr(brush);
        return sharedPtr;
    }

    /******************************************************************************
     *  Render
     ******************************************************************************/
    void GlRadialGradientBrushBlend::Render(SurfaceHandle /*input*/, const Rectangle& /*inputArea*/, const Matrix3x2& transform,
                                           const Node2D& node, ContextHandle2D output, Rectangle& outputArea)
    {
        CANDERA_PERF_RECORDER(Timing, (FeatStd::PerfMon::TimingRecId::RenderEffect2D, "GlRadialGradientBrushBlend"));

        if (m_gradientBrush.Size().Get() != Vector2(0.0F, 0.0F)) {
            m_blendEffect.ActivateBlend(output);
            m_gradientBrush.Activate(node, output);
            m_gradientBrush.RenderGradient(transform, output, outputArea);
            m_gradientBrush.Deactivate(output);
            m_blendEffect.DeactivateBlend(output);
        }
    }

    /******************************************************************************
     *  Clone
     ******************************************************************************/
    Effect2D::SharedPointer GlRadialGradientBrushBlend::Clone() const
    {
        return Effect2D::SharedPointer(CANDERA_NEW(GlRadialGradientBrushBlend)(*this));
    }

}   // namespace Candera
