//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlLinearGradientBrushBlend.h"
#include <Candera/System/Monitor/PerfMonPublicIF.h>

namespace Candera {
    FEATSTD_RTTI_DEFINITION(GlLinearGradientBrushBlend, CombinedEffect2D)

    /******************************************************************************
     *  Constructor
     ******************************************************************************/
    GlLinearGradientBrushBlend::GlLinearGradientBrushBlend()
    {
    }

    GlLinearGradientBrushBlend::GlLinearGradientBrushBlend(const GlLinearGradientBrushBlend& rhs) :
        Base(rhs),
        m_gradientBrush(rhs.m_gradientBrush),
        m_blendEffect(rhs.m_blendEffect)
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    GlLinearGradientBrushBlend::~GlLinearGradientBrushBlend()
    {
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    GlLinearGradientBrushBlend::SharedPointer GlLinearGradientBrushBlend::Create()
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

        GlLinearGradientBrushBlend* brush = FEATSTD_NEW(GlLinearGradientBrushBlend);
        FEATSTD_DEBUG_ASSERT(brush != 0);

        GlLinearGradientBrushBlend::SharedPointer sharedPtr(brush);
        return sharedPtr;
    }

    /******************************************************************************
     *  Render
     ******************************************************************************/
    void GlLinearGradientBrushBlend::Render(SurfaceHandle /*input*/, const Rectangle& /*inputArea*/, const Matrix3x2& transform,
                                           const Node2D& node, ContextHandle2D output, Rectangle& outputArea)
    {
        CANDERA_PERF_RECORDER(Timing, (FeatStd::PerfMon::TimingRecId::RenderEffect2D, "GlLinearGradientBrushBlend"));

        if (m_gradientBrush.Size().Get() != Vector2(0.0F, 0.0F)) {
            m_blendEffect.ActivateBlend(output);
            m_gradientBrush.Activate(node, output);
            m_gradientBrush.RenderGradient(transform, output, outputArea);
            m_gradientBrush.Deactivate(output);
            m_blendEffect.DeactivateBlend(output);
        }
    }

    /******************************************************************************
     *  Clone
     ******************************************************************************/
    Effect2D::SharedPointer GlLinearGradientBrushBlend::Clone() const
    {
        return Effect2D::SharedPointer(CANDERA_NEW(GlLinearGradientBrushBlend)(*this));
    }

}   // namespace Candera
