//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLFLIP_BITMAPBRUSHBLEND_H)
#define CANDERA_GLFLIP_BITMAPBRUSHBLEND_H

#include <Candera/Engine2D/Effects/CombinedEffect2D.h>
#include <CanderaPlatform/Device/Common/Effects/BitmapBrush.h>
#include <CanderaPlatform/Device/Common/Internal/RenderDevice2DOver3D/Effects/GlFlipEffect.h>
#include <CanderaPlatform/Device/Common/Effects/BlendEffect.h>

namespace Candera {

    /** @brief    This effect flips the coresponding bitmap image and blend it with the store buffer.
     *            Same as chaining (BitmapBrush + GlFlipEffect + BlendEffect)
     *            @see Candera::BitmapBrush
     *            @see Candera::GlFlipEffect
     *            @see Candera::BlendEffect
     */
    class GlFlipBitmapBrushBlend : public CombinedEffect2D {
        FEATSTD_TYPEDEF_BASE(CombinedEffect2D);

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(GlFlipBitmapBrushBlend);
        FEATSTD_RTTI_DECLARATION();

        /**
         *  Creates an instance of this class
         *  @return A pointer to the created object.
         */
        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        /**
         *  Retrieves the bitmap brush.
         *  @return     The bitmap brush.
         */
        const BitmapBrush& GetBitmapBrush() const { return m_bitmapBrush; }
        BitmapBrush& GetBitmapBrush() { return m_bitmapBrush; }

        /**
         *  Retrieves the flip effect.
         *  @return     The flip effect.
         */
        const GlFlipEffect& GetFlipEffect() const { return m_flipEffect; }
        GlFlipEffect& GetFlipEffect() { return m_flipEffect; }

        /**
         *  Retrieves the blend effect.
         *  @return     The blend effect.
         */
        const BlendEffect& GetBlendEffect() const { return m_blendEffect; }
        BlendEffect& GetBlendEffect() { return m_blendEffect; }


        // overrides Effect2D::GetBrushEffect2D
        virtual BrushEffect2D* GetBrushEffect2D() override { return &m_bitmapBrush; }

        // overrides Effect2D::GetInPlaceEffect2D
        virtual InPlaceEffect2D* GetInPlaceEffect2D(UInt8 index) { return (index == 0) ? &m_flipEffect: 0; }

        // overrides Effect2D::GetBlendEffect2D
        virtual BlendEffect2D* GetBlendEffect2D() override { return &m_blendEffect; }

        // overrides Effect2D::Upload
        virtual bool Upload();

        // overrides Effect2D::Unload
        virtual bool Unload();

        // overrides Effect2D::Update
        virtual bool Update();

        // overrides Effect2D::Clone
        virtual Effect2D::SharedPointer Clone() const override;

        /// @cond excluded from doxygen
        CdaEffect2DCombinedDef(Candera::GlFlipBitmapBrushBlend, GlFlipBitmapBrushBlend, EFFECT2D_TYPE_BRUSH, EFFECT2D_TYPE_BLEND)

            CdaDescription("This effect flips the coresponding bitmap image and blend it with the store buffer.")
            CdaEffect2DProperties()

                 CdaEffect2DImportProperties(GlBitmapBrush, Candera::BitmapBrush, m_bitmapBrush)
                 CdaEffect2DImportProperties(GlFlipEffect, Candera::GlFlipEffect, m_flipEffect)
                 CdaEffect2DImportProperties(BlendEffect, Candera::BlendEffect, m_blendEffect)

            CdaEffect2DPropertiesEnd()
        CdaEffect2DDefEnd()
        /// @endcond

    protected:
        // Explicit protected Constructor and Copy-Constructor, use Create() to create an instance of this object.
        GlFlipBitmapBrushBlend();
        explicit GlFlipBitmapBrushBlend(const GlFlipBitmapBrushBlend& rhs);
        virtual ~GlFlipBitmapBrushBlend();
        GlFlipBitmapBrushBlend& operator = (const GlFlipBitmapBrushBlend& rhs);

        // overrides Effect2D::Render
        virtual void Render(SurfaceHandle input, const Rectangle& inputArea, const Matrix3x2& transform, const Node2D& node, ContextHandle2D output, Rectangle& outputArea) override;

    private:
         // Use class wrappers to forward protected members.
        class BitmapBrushWrapper : public BitmapBrush {
          public:
                using BitmapBrush::Render;
        } m_bitmapBrush;
        class GlFlipEffectWrapper: public GlFlipEffect {} m_flipEffect;
        class BlendEffectWrapper : public BlendEffect {} m_blendEffect;
    };

}   // namespace Candera

#endif  // CANDERA_GLFLIP_BITMAPBRUSHBLEND_H

