//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CONTEXT_2D_OVER_3D_TARGET)
#define CONTEXT_2D_OVER_3D_TARGET

#include <Candera/System/Mathematics/Matrix3x2.h>
#include <Candera/System/Mathematics/Matrix4.h>
#include <Candera/System/Mathematics/Vector2.h>
#include <Candera/System/Mathematics/Rectangle.h>

#include <Candera/EngineBase/Common/Color.h>

#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>

#include <Candera/Engine3D/Core/Shader.h>
#include <Candera/Engine3D/Core/VertexBuffer.h>
#include <Candera/Engine3D/Core/Texture.h>
#include <Candera/Engine3D/Core/RenderMode.h>


namespace Candera {

    namespace Internal {

        /**
        * @brief Structure that contains the immutable data within this context,
        * which is mostly properties of the render target.
        *
        * This class defines the transformation from Candera 2D space to
        * Candera 3D space.
        */
        class Context2DOver3DTarget{
        public:
            /**
            * Constructor.
            */
            Context2DOver3DTarget();


            Float width; ///< Width of the target as interpreted by Candera 2D.
            Float height; ///< Height of the target as interpreted by Candera 2D.

            Float actualWidth; ///< Width of the render target used in setting the viewport.
            Float actualHeight; ///< Height of the render target used in setting the viewport.
        };

    }
}



#endif
