//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CONTEXT_2D_OVER_3D_STATE)
#define CONTEXT_2D_OVER_3D_STATE

#include <Candera/System/Mathematics/Matrix3x2.h>
#include <Candera/System/Mathematics/Matrix4.h>
#include <Candera/System/Mathematics/Vector2.h>
#include <Candera/System/Mathematics/Rectangle.h>

#include <Candera/EngineBase/Common/Color.h>

#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>

#include <Candera/Engine3D/Core/Shader.h>
#include <Candera/Engine3D/Core/VertexBuffer.h>
#include <Candera/Engine3D/Core/Texture.h>
#include <Candera/Engine3D/Core/RenderMode.h>

namespace Candera {

    namespace Internal {

        /**
         * @brief Structure that holds the mutable data within this context.
         * This data is updated by RenderDevice2D as states of the context change.
         *
         * All values within this class are in the space of Candera 2D.
         */
        class Context2DOver3DState{
        public:

            CANDERA_LINT_DECLARE_INITIALIZER_FUNCTION(Candera::Context2DOver3D::Context::Initialize)

            /**
             * Constructor
             */
            Context2DOver3DState();

            /**
             * Function used to set all the states to default.
             */
            void Initialize();

            // destination context
            Rectangle dstArea; ///< Active area of the destination surface. Used as viewport.
            bool isScissorEnabled;
            Rectangle userScissorRectangle;

            // source context
            Matrix3x2 srcMatrix; ///< Transformation matrix of the source surface.
            Matrix3x2 mskTrans;
            Rectangle srcArea; ///< Active area of the source surface. Used as clipping rectangle.        
            Color srcConstColor; ///< Constant color of the source surface. Used for color modulation.
            Color gradientColor; ///< Constant color of the gradient effect. Used along with src const color.
            Vector2 gradientCenter;
            Vector2 gradientDirection;
            Float gradientMagnitude;
            Matrix4 srcColorMatrix;
            bool srcColorMatrixEnabled;

            bool flipH;
            bool flipV;

            //Outline Effect
            Color outlineColor;
            UInt8 outlineWidth;
            Vector2 outlinePixelDimensions;

            //DropShadow Effect
            bool enableShadow;
            Vector2 offset;
            Color shadowColor;
            Int angle;
            Int distance;
            Int scale;
            Int colorFactor;
            bool blurFilter;

            MemoryManagement::SharedPointer<RenderMode> renderMode; ///< Render mode used when rendering content.
            RenderDevice2D::PackOrder srcPackOrder; ///< Pack order of the source surface. Used to determine flipping.
            RenderDevice2D::PackOrder mskPackOrder;

            MemoryManagement::SharedPointer<Texture> srcTexture; ///< Texture to which texture states are linked, including the texture image.
            MemoryManagement::SharedPointer<Texture> mskTexture;

            // operational information
            Rectangle lastUpdatedArea; ///< Rectangle bounding the result of the last draw operation.
        };
    }
}

#endif
