//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Context2DOver3DState.h"

namespace Candera {
    namespace Internal {

        Context2DOver3DState::Context2DOver3DState():
            gradientMagnitude(0.0F),
            srcColorMatrixEnabled(false),
            flipH(false),
            flipV(false),
            outlineWidth(0),
            srcPackOrder(RenderDevice2D::UnknownPackOrder),
            mskPackOrder(RenderDevice2D::UnknownPackOrder)
        {
            Initialize();
        }

        void Context2DOver3DState::Initialize()
        {
            dstArea.SetLeft(0.F);
            dstArea.SetTop(0.F);
            dstArea.SetWidth(-1.F);
            dstArea.SetHeight(-1.F);

            srcMatrix.SetIdentity();
            mskTrans.SetIdentity();

            srcArea.SetLeft(0.F);
            srcArea.SetTop(0.F);
            srcArea.SetWidth(-1.F);
            srcArea.SetHeight(-1.F);

            srcConstColor.Set(1.0F, 1.0F, 1.0F, 1.0F);

            gradientColor.Set(0.0F, 0.0F, 0.0F, 1.0F);

            outlineColor.Set(1.0F, 1.0F, 1.0F, 1.0F);


            srcColorMatrixEnabled = false;
            srcColorMatrix.SetIdentity();

            flipH = false;
            flipV = false;

            renderMode = RenderMode::Create();
            if (renderMode != 0) {
                renderMode->SetDepthWriteEnabled(false);
                renderMode->SetDepthTestEnabled(false);
                renderMode->SetCulling(RenderMode::NoCulling);
            }

            srcTexture = Texture::Create();
            if (srcTexture != 0) {
                srcTexture->SetWrapModeU(Texture::ClampToEdge);
                srcTexture->SetWrapModeV(Texture::ClampToEdge);
            }
            mskTexture = Texture::Create();
            if (mskTexture != 0) {
                mskTexture->SetWrapModeU(Texture::ClampToEdge);
                mskTexture->SetWrapModeV(Texture::ClampToEdge);
            }

            lastUpdatedArea.SetLeft(0.F);
            lastUpdatedArea.SetTop(0.F);
            lastUpdatedArea.SetWidth(0.F);
            lastUpdatedArea.SetHeight(0.F);

            isScissorEnabled = false;
            userScissorRectangle.Set(0.0F, 0.0F, -1.0F, -1.0F);

            shadowColor.Set(1.0F, 1.0F, 1.0F, 1.0F);
            angle = 0;
            distance = 0;
            scale = 0;
            colorFactor = 0;
            blurFilter = false;
            enableShadow = false;

        }

    }
}
