//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Context2DOver3DDevicePool.h"
#include <CanderaPlatform/Device/Common/Internal/RenderDevice2DOver3D/ShaderDefinitionsFor2DOver3D.h>
#include <FeatStd/Platform/Memory.h>

namespace Candera {
    namespace Internal {

        const VertexGeometry::VertexElementFormat Context2DOver3DDevicePool::VertexFormat[] = {
            { 0, VertexGeometry::Float32_2, VertexGeometry::Position, 0 },
            { 8, VertexGeometry::Float32_2, VertexGeometry::TextureCoordinate, 0 }
        };

        static Context2DOver3DDevicePool& s_forceInitGetInstance = Context2DOver3DDevicePool::GetInstance();

        Context2DOver3DDevicePool& Context2DOver3DDevicePool::GetInstance()
        {
            FEATSTD_UNSYNCED_STATIC_OBJECT(Context2DOver3DDevicePool, pool);
            return pool;
        }

        Context2DOver3DDevicePool::~Context2DOver3DDevicePool()
        {
            Context2DOver3DDevicePool::DisposeInternal();
        }

        Context2DOver3DDeviceProgram* Context2DOver3DDevicePool::GetProgram(Context2DOver3DDeviceProgram::ProgramType type) const
        {
            Context2DOver3DDeviceProgram* result = 0;
            if (type < Context2DOver3DDeviceProgram::ProgramsCount) {
                if (!m_programLoaded[type]) {
                    if (!m_programPool[type]->Upload()) {
                        return result;
                    }
                    m_programLoaded[type] = true;
                }
                result =  m_programPool[type];
            }

            return result;
        }


        bool Context2DOver3DDevicePool::UploadInternal(LoadingHint /*loadingHint*/)
        {
            if (!m_vertexBuffer->Upload()) {
                return false;
            }

            return true;
        }

        bool Context2DOver3DDevicePool::UnloadInternal(LoadingHint /*loadingHint*/)
        {
            for (UInt32 i = 0; i < Context2DOver3DDeviceProgram::ProgramsCount; i++) {
                m_programLoaded[i] = false;
                if (m_programPool[i] != 0) {
                    if (!m_programPool[i]->Unload()) {
                        return false;
                    }
                }
            }

            if (!m_vertexBuffer->Unload()) {
                return false;
            }

            return true;
        }

        void Context2DOver3DDevicePool::DisposeInternal()
        {
            for (UInt32 i = 0; i < Context2DOver3DDeviceProgram::ProgramsCount; i++) {
                m_programLoaded[i] = false;
                if (m_programPool[i] != 0) {
                    static_cast<void>(m_programPool[i]->Unload());
                    FEATSTD_DELETE(m_programPool[i]);
                }
            }

            static_cast<void>(m_vertexBuffer->Unload(Force));
        }

        Context2DOver3DDevicePool::Context2DOver3DDevicePool() :
            Base(),
            m_vertexBuffer(VertexBuffer::Create()),
            m_isCustomVertexBufferNormalized(true)
        {
            FeatStd::Internal::Memory::Set(m_programLoaded, 0, sizeof(m_programLoaded));

            BEGIN_BUILD_SHADER
               BUILD_SHADER(Context2DOver3DDeviceProgram::RGBABlit, TEXTURE_VERTEX_SHADER, TEXTURE_RGBA_PIXEL_SHADER, FeatStd::Internal::Guid("B0383905-B858-4329-919C-4330207AF956"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCABlit, TEXTURE_VERTEX_SHADER, TEXTURE_CCCA_PIXEL_SHADER, FeatStd::Internal::Guid("14759487-F7A8-4518-9A04-68752DC08B00"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCCBlit, POSITION_VERTEX_SHADER, TEXTURE_CCCC_PIXEL_SHADER, FeatStd::Internal::Guid("1F6BCD9E-9CDE-420D-8ADA-A0934CB168C0"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::RGBABlitMaskMul, MASK_TEXTURE_VERTEX_SHADER, MASK_MUL_RGBA_PIXEL_SHADER, FeatStd::Internal::Guid("26F23D96-2933-4055-B855-5B318A3EF2E3"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCABlitMaskMul, MASK_TEXTURE_VERTEX_SHADER, MASK_MUL_CCCA_PIXEL_SHADER, FeatStd::Internal::Guid("60BF2878-638A-4441-8F94-644E291216FE"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCCBlitMaskMul, MASK_TEXTURE_VERTEX_SHADER, MASK_MUL_CCCC_PIXEL_SHADER, FeatStd::Internal::Guid("A3468E82-177E-402E-BE9B-EED8A7AF1195"))

               BUILD_SHADER(Context2DOver3DDeviceProgram::RGBABlitTransformed, TEXTURE_VERTEX_SHADER, TRANSFORM_RGBA_PIXEL_SHADER, FeatStd::Internal::Guid("C69AD9C7-5C45-4AE8-BC42-CA9771E074D4"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCABlitTransformed, TEXTURE_VERTEX_SHADER, TRANSFORMED_CCCA_PIXEL_SHADER, FeatStd::Internal::Guid("9162CCE4-19AD-45E4-9EA0-DA29CAE08ADD"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCCBlitTransformed, POSITION_VERTEX_SHADER, TRANSFORMED_CCCC_PIXEL_SHADER, FeatStd::Internal::Guid("C411A805-47D8-4AED-934E-D3EA6F792CC3"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::RGBABlitMaskMulTransformed, MASK_TEXTURE_VERTEX_SHADER, TRANSFORMED_MASK_MUL_RGBA_PIXEL_SHADER, FeatStd::Internal::Guid("AEC0004D-D3D2-4E2A-9962-76AF9424CC83"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCABlitMaskMulTransformed, MASK_TEXTURE_VERTEX_SHADER, TRANSFORM_MASK_MUL_CCCA_PIXEL_SHADER, FeatStd::Internal::Guid("E248D1C0-4FA1-471B-AD08-352BBEB71D2A"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCCBlitMaskMulTransformed, MASK_TEXTURE_VERTEX_SHADER, TRANSFORM_MASK_MUL_CCCC_PIXEL_SHADER, FeatStd::Internal::Guid("DFA90CDE-2BCD-4CBB-B3AF-CF47A5AEB2AF"))

               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCABlitLinearGradient, GRADIENT_VERTEX_SHADER, LINEAR_GRADIENT_COLOR_PIXEL_SHADER, FeatStd::Internal::Guid("E8EC0F5F-2A5B-402D-BF30-AA10C84E07D7"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCABlitRadialGradient, GRADIENT_VERTEX_SHADER, RADIAL_GRADIENT_COLOR_PIXEL_SHADER, FeatStd::Internal::Guid("0942DCCE-6A0E-4B45-8EE8-4BEB6826D84E"))

               BUILD_SHADER(Context2DOver3DDeviceProgram::RGBABlitOutline, OUTLINE_VERTEX_SHADER, TEXTURE_CCCA_OUTLINE_PIXEL_SHADER, FeatStd::Internal::Guid("B32FADBB-DA97-4E49-A776-5931680A2E5C"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCABlitOutline, OUTLINE_VERTEX_SHADER, TEXTURE_CCCA_OUTLINE_PIXEL_SHADER, FeatStd::Internal::Guid("C774B45B-1FF8-4561-89FA-E1DE3258644C"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCCBlitOutline, OUTLINE_VERTEX_SHADER, TEXTURE_CCCA_OUTLINE_PIXEL_SHADER, FeatStd::Internal::Guid("0BB51C1F-45F1-4448-A377-51AE007D62A0"))

               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCABlitDropShadowNoBlur, DROPSHADOW_VERTEX_SHADER, TEXTURE_CCCA_DROPSHADOW_NO_BLUR_PIXEL_SHADER, FeatStd::Internal::Guid("E21D1082-173B-4467-BF92-9C9D12E53CF5"))
               BUILD_SHADER(Context2DOver3DDeviceProgram::CCCABlitDropShadow3x3Blur, DROPSHADOW_VERTEX_SHADER, TEXTURE_CCCA_DROPSHADOW_3X3_BLUR_PIXEL_SHADER, FeatStd::Internal::Guid("6E3A5627-23F5-489B-82F6-1F5CC0492C1A"))
            END_BUILD_SHADER

            if (m_vertexBuffer != 0) {
                static const Vertex vertices[] = {
                //   x      y      u     v
                    { 0.0F, 0.0F,  0.0F, 0.0F },
                    { 0.0F, 1.0F,  0.0F, 1.0F },
                    { 1.0F, 0.0F,  1.0F, 0.0F },
                    { 1.0F, 1.0F,  1.0F, 1.0F }
                 };
                CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1938, "accesses static const global data [MISRA C++ Rule 12-8-1]")
                static VertexGeometry vertexGeometry(
                    vertices, 0,
                    VertexFormat, 0,
                    0, 0,
                    4, sizeof(Vertex), 2, 0,
                    VertexGeometry::VideoMemory,
                    VertexGeometry::ArrayBuffer,
                    VertexGeometry::StaticWrite);

                static_cast<void>(m_vertexBuffer->SetVertexGeometry(&vertexGeometry, 0));
                m_vertexBuffer->SetPrimitiveType(VertexBuffer::TriangleStrip);
            }
        }

    }
}
