//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Gl2D_SHADER_DEFINITIONS_H
#define Gl2D_SHADER_DEFINITIONS_H

#include <CanderaConfig.h>

#if defined(CGIDEVICE_TARGET_BUILD) && defined(CANDERA_EXTERNAL_SHADER_BUILDER_HEADER_INCLUDE)
#include CANDERA_EXTERNAL_SHADER_BUILDER_HEADER_INCLUDE
#else

#define BEGIN_BUILD_SHADER

#define BUILD_SHADER(NAME, VERTEX, PIXEL, SHADER_GUID) \
    { \
        const void* vShaderStr = \
            VERTEX("", "") \
        const void* fShaderStr = \
            PIXEL("", "") \
            m_programPool[NAME] = FEATSTD_NEW(Context2DOver3DDeviceProgram)(vShaderStr, fShaderStr, NAME, SHADER_GUID); \
    }

#define END_BUILD_SHADER

#endif // if defined(CGIDEVICE_TARGET_BUILD) && defined(CANDERA_EXTERNAL_SHADER_BUILDER_HEADER_INCLUDE)

#ifdef CANDERA_DEVICE_EMERALD
#define SHADER(DECLARATIONS, BODY) \
            "#ifndef GL_ES\n" \
            "#define lowp\n" \
            "#define mediump\n" \
            "#define highp\n" \
            "#define precision\n" \
            "#endif\n" \
            "precision mediump float;\n" \
            DECLARATIONS \
            "void main()\n" \
            "{\n" \
            BODY \
            "}\n";
#elif CANDERA_DEVICE_RCARD3 
#define SHADER(DECLARATIONS, BODY) \
            "#define CANDERA_DEVICE_RCARD3\n" \
            "#ifndef GL_ES\n" \
            "#define lowp\n" \
            "#define mediump\n" \
            "#define highp\n" \
            "#define precision\n" \
            "#endif\n" \
            "precision highp float;\n" \
            DECLARATIONS \
            "void main()\n" \
            "{\n" \
            BODY \
            "}\n";
#else
#define SHADER(DECLARATIONS, BODY) \
            "#ifndef GL_ES\n" \
            "#define lowp\n" \
            "#define mediump\n" \
            "#define highp\n" \
            "#define precision\n" \
            "#endif\n" \
            "precision highp float;\n" \
            DECLARATIONS \
            "void main()\n" \
            "{\n" \
            BODY \
            "}\n";
#endif


#define POSITION_VERTEX_SHADER(DECLARATIONS, BODY) \
        SHADER( \
            "uniform mat4 u_Transform;\n" \
            "attribute vec4 a_Position;\n" \
            DECLARATIONS, \
            "   gl_Position = a_Position * u_Transform;\n" \
            BODY)

#define GRADIENT_VERTEX_SHADER(DECLARATIONS, BODY) \
        POSITION_VERTEX_SHADER( \
            "varying vec2 v_TexCoord;\n" \
            DECLARATIONS, \
            "   v_TexCoord.xy = a_Position.xy;\n" \
            BODY)

#define TEXTURE_VERTEX_SHADER(DECLARATIONS, BODY) \
        POSITION_VERTEX_SHADER( \
            "uniform mat4 u_TexTransform;\n" \
            "attribute vec4 a_TextureCoordinate;\n" \
            "varying vec2 v_TexCoord;\n" \
            DECLARATIONS, \
            "   v_TexCoord.xy = (a_TextureCoordinate * u_TexTransform).xy;\n" \
            BODY)

#define MASK_VERTEX_SHADER_BUILDER(MACRO_NAME, DECLARATIONS, BODY) \
        MACRO_NAME( \
            "uniform mat4 u_MaskTransform;\n" \
            "varying vec2 v_MaskCoord;\n" \
            DECLARATIONS, \
            "   v_MaskCoord.xy = (a_Position * u_MaskTransform).xy;\n" \
            BODY)

#define MASK_TEXTURE_VERTEX_SHADER(DECLARATIONS, BODY) \
        MASK_VERTEX_SHADER_BUILDER( \
            TEXTURE_VERTEX_SHADER, \
            DECLARATIONS, \
            BODY)

#define CONSTANT_COLOR_PIXEL_SHADER(DECLARATIONS, BODY) \
        SHADER( \
            "uniform vec4 u_ConstTexColor;\n" \
            DECLARATIONS, \
            "   vec4 color = u_ConstTexColor;\n" \
            BODY \
            "   gl_FragColor = color;\n")

#define GRADIENT_COLOR_PIXEL_SHADER(DECLARATIONS, BODY) \
        CONSTANT_COLOR_PIXEL_SHADER( \
            "   uniform vec4 u_constGradientColor;\n" \
            "   uniform mediump float u_magnitude;\n" \
            "   uniform mediump vec2 u_center;\n" \
            "   uniform mediump vec2 u_direction;\n" \
            "   varying vec2 v_TexCoord;\n" \
            DECLARATIONS, \
            BODY \
            "   color = u_constGradientColor * percentage + color * (1.0 - percentage);\n")

#define LINEAR_GRADIENT_COLOR_PIXEL_SHADER(DECLARATIONS, BODY) \
        GRADIENT_COLOR_PIXEL_SHADER( \
            DECLARATIONS, \
            "   float percentage = clamp((((dot(u_direction, v_TexCoord - u_center) * u_magnitude) + 1.0) * 0.5), 0.0, 1.0);\n" \
            BODY)

#define RADIAL_GRADIENT_COLOR_PIXEL_SHADER(DECLARATIONS, BODY) \
        GRADIENT_COLOR_PIXEL_SHADER( \
            DECLARATIONS, \
            "   float percentage = clamp(distance(u_center, v_TexCoord) * u_magnitude, 0.0, 1.0);\n" \
            BODY)

#define TRANSFORMED_COLOR_PIXEL_SHADER_BUILDER(MACRO_NAME, DECLARATIONS, BODY) \
    MACRO_NAME( \
        "uniform mat4 u_ColorTransform;\n" \
        DECLARATIONS, \
        "  color.rgb = (vec4(color.rgb, 1) * u_ColorTransform).rgb;\n" \
        BODY)

#define TEXTURE_RGBA_PIXEL_SHADER(DECLARATION, BODY) \
        CONSTANT_COLOR_PIXEL_SHADER( \
            "uniform sampler2D u_Texture;\n" \
            "varying vec2 v_TexCoord;\n" \
            DECLARATION, \
            "   color = color * texture2D(u_Texture, v_TexCoord);\n" \
            BODY)

#define TEXTURE_CCCA_PIXEL_SHADER(DECLARATION, BODY) \
        CONSTANT_COLOR_PIXEL_SHADER( \
            "uniform sampler2D u_Texture;\n" \
            "varying vec2 v_TexCoord;\n" \
            DECLARATION, \
            "   color.a = color.a * texture2D(u_Texture, v_TexCoord).a;\n" \
            BODY)

#define OUTLINE_VERTEX_SHADER(DECLARATIONS, BODY) \
    POSITION_VERTEX_SHADER(\
    "uniform mat4 u_TexTransform;\n" \
    "uniform lowp float u_outlineWidth;\n" \
    "uniform vec2 u_pixelDimension;\n" \
    "varying vec2 v_TexCoord;\n" \
    DECLARATIONS, \
    "   vec2 texCoord = (a_Position * u_TexTransform).xy;\n" \
    "   texCoord.x = texCoord.x * (1.0 + (2.0 * u_outlineWidth * u_pixelDimension.x)) - u_outlineWidth * u_pixelDimension.x;\n" \
    "   texCoord.y = texCoord.y * (1.0 + (2.0 * u_outlineWidth * u_pixelDimension.y)) - u_outlineWidth * u_pixelDimension.y;\n" \
    "   v_TexCoord = texCoord;\n" \
    BODY)

#define TEXTURE_CCCA_OUTLINE_PIXEL_SHADER(DECLARATION, BODY) \
    CONSTANT_COLOR_PIXEL_SHADER(\
    "uniform sampler2D u_Texture;\n" \
    "uniform vec4 u_outlineColor;\n" \
    "uniform lowp float u_outlineWidth;\n" \
    "uniform vec2 u_pixelDimension;\n" \
    "uniform lowp float u_colorFactor;\n" \
    "varying vec2 v_TexCoord;\n" \
    "vec4 GetTexel(vec2 pos){ \n" \
    "   vec4 result = vec4(0.0);\n" \
    "#if defined (CANDERA_DEVICE_RCARD3)\n" \
    "   result = step(1.9, dot(step(vec2(0.0, 0.0), pos), -step(vec2(-1.0, -1.0), -pos)))*texture2D(u_Texture, pos);\n" \
    "#else\n" \
    "   if (all(greaterThan(pos, vec2(0.0, 0.0))) && all(lessThan(pos, vec2(1.0, 1.0)))) {\n" \
    "      result = texture2D(u_Texture, pos);\n" \
    "   }\n" \
    "#endif\n" \
    "   return result;" \
    "}\n" \
    "vec4 GetOutline(vec2 pos, float xoff, float yoff){ \n" \
    "    vec4 pixel     = GetTexel(vec2(pos.x + xoff,            pos.y +yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x + 0.5 * xoff,    pos.y +yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x + xoff,            pos.y + 0.5 * yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x + xoff,            pos.y -yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x + 0.5 * xoff,    pos.y - yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x + xoff,            pos.y - 0.5 *yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x - xoff,            pos.y +yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x - 0.5 * xoff,    pos.y +yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x - xoff,            pos.y + 0.5 * yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x - xoff,            pos.y -yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x - 0.5 * xoff,    pos.y -yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x - xoff,            pos.y - 0.5 * yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x,                    pos.y +yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x,                    pos.y -yoff));\n" \
    "    pixel        += GetTexel(vec2(pos.x + xoff,            pos.y));\n" \
    "    pixel        += GetTexel(vec2(pos.x - xoff,            pos.y));\n" \
    "   return pixel;}\n" \
    DECLARATION, \
    "   float image = GetTexel(v_TexCoord).a; \n" \
    "   vec4 textureColor = min(vec4(1.0), vec4(vec3(u_colorFactor), 0.0) + GetTexel(v_TexCoord)); \n" \
    "   vec4 outline = vec4( u_outlineColor.rgb ,GetOutline(v_TexCoord, u_outlineWidth * u_pixelDimension.x, u_outlineWidth * u_pixelDimension.y).a); \n" \
    "   color = vec4(color.rgb * textureColor.rgb * image, image) + vec4(outline.rgb *(1.0-image), outline.a); \n" \
    BODY)

#define DROPSHADOW_VERTEX_SHADER(DECLARATIONS, BODY) \
    POSITION_VERTEX_SHADER(\
    "uniform mat4 u_TexTransform;\n" \
    "uniform lowp float u_scale;\n" \
    "uniform vec2 u_pixelDimension;\n" \
    "uniform vec2 u_offset;\n" \
    "varying vec2 v_TexCoord;\n" \
    DECLARATIONS, \
    "   vec2 texCoord = (a_Position * u_TexTransform).xy;\n" \
    "   vec2 leftTop = min(u_offset - vec2(u_scale, u_scale), vec2(0.0, 0.0));\n" \
    "   vec2 rightBottom = max(vec2(0.0, 0.0), u_offset + vec2(u_scale, u_scale));\n" \
    "   v_TexCoord = texCoord * (vec2(1.0, 1.0) + u_pixelDimension * (rightBottom - leftTop)) + leftTop * u_pixelDimension;\n" \
    BODY)

#define FUNCTION_NO_BLUR \
    "   float GetBorder(vec2 pos, vec2 offset)                                       \n" \
    "   {                                                                            \n" \
    "       return GetTexAlpha(pos);                                                 \n" \
    "   }                                                                            \n" \

#define FUNCTION_3X3_BLUR \
    "   float GetBorder(vec2 pos, vec2 offset)                                      \n" \
    "   {                                                                           \n" \
    "      vec2 posMinusOffset = pos - offset;                                      \n" \
    "      vec2 posPlusOffset = pos + offset;                                       \n" \
    "      return (GetTexAlpha(posMinusOffset)                                      \n" \
    "            + GetTexAlpha(vec2(posMinusOffset.x, posPlusOffset.y))             \n" \
    "            + GetTexAlpha(vec2(posPlusOffset.x, posMinusOffset.y))             \n" \
    "            + GetTexAlpha(posPlusOffset)                                       \n" \
    "       + 2.0 * (GetTexAlpha(vec2(posMinusOffset.x, pos.y))                     \n" \
    "            + GetTexAlpha(vec2(posPlusOffset.x, pos.y))                        \n" \
    "            + GetTexAlpha(vec2(pos.x, posMinusOffset.y))                       \n" \
    "            + GetTexAlpha(vec2(pos.x, posPlusOffset.y)))                       \n" \
    "        + 4.0 * GetTexAlpha(pos)) * 0.0625;                                    \n" \
    "   }                                                                           \n" \

#define TEXTURE_CCCA_DROPSHADOW_PIXEL_SHADER(DECLARATION, FUNCTION_BLUR, BODY) \
    CONSTANT_COLOR_PIXEL_SHADER(\
    "uniform sampler2D u_Texture;\n" \
    "uniform vec4 u_shadowColor;\n" \
    "uniform lowp float u_scale;\n" \
    "uniform lowp float u_colorFactor;\n" \
    "uniform vec2 u_pixelDimension;\n" \
    "uniform vec2 u_offset;\n" \
    "varying vec2 v_TexCoord;\n" \
    "float GetTexAlpha(vec2 pos)\n" \
    "{\n" \
    "   float result = 0.0;\n" \
    "#if defined (CANDERA_DEVICE_RCARD3)\n" \
    "   result = step(1.9, dot(step(vec2(0.0, 0.0), pos), -step(vec2(-1.0, -1.0), -pos)))*texture2D(u_Texture, pos).a;\n" \
    "#else\n" \
    "   if (all(greaterThanEqual(pos, vec2(0.0, 0.0))) && all(lessThanEqual(pos, vec2(1.0, 1.0)))) {\n" \
    "      result = texture2D(u_Texture, pos).a;\n" \
    "   }\n" \
    "#endif\n" \
    "   return result;" \
    "}\n" \
    FUNCTION_BLUR \
    DECLARATION, \
    "vec4 textureColor = min(vec4(1.0), vec4(vec3(u_colorFactor), 0.0) + texture2D(u_Texture, v_TexCoord));\n" \
    "float inside = GetTexAlpha(v_TexCoord);\n" \
    "float outside = GetBorder(v_TexCoord - u_offset * u_pixelDimension, u_pixelDimension * u_scale);\n" \
    "vec4 colorA = vec4(color.rgb * textureColor.rgb * inside, inside); \n" \
    "vec4 colorB = vec4(u_shadowColor.rgb, u_shadowColor.a * outside); \n" \
    "color = vec4(colorA.rgb, 0.0) + colorB;\n" \
    BODY)


#define TEXTURE_CCCA_DROPSHADOW_NO_BLUR_PIXEL_SHADER(DECLARATION, BODY) \
    TEXTURE_CCCA_DROPSHADOW_PIXEL_SHADER(DECLARATION, FUNCTION_NO_BLUR, BODY)

#define TEXTURE_CCCA_DROPSHADOW_3X3_BLUR_PIXEL_SHADER(DECLARATION, BODY) \
    TEXTURE_CCCA_DROPSHADOW_PIXEL_SHADER(DECLARATION, FUNCTION_3X3_BLUR, BODY)


#define TEXTURE_CCCC_PIXEL_SHADER CONSTANT_COLOR_PIXEL_SHADER

#define MASK_PIXEL_SHADER_BUILDER(MACRO_NAME, DECLARATIONS, BODY) \
        MACRO_NAME( \
            "uniform vec4 u_constMaskColor;\n" \
            "uniform sampler2D u_Texture1;\n" \
            "varying vec2 v_MaskCoord;\n" \
            DECLARATIONS, \
            "       color.a = texture2D(u_Texture1, v_MaskCoord).a * color.a;\n" \
            BODY)

#define MASK_MUL_RGBA_PIXEL_SHADER(DECLARATIONS, BODY) \
        MASK_PIXEL_SHADER_BUILDER( \
            TEXTURE_RGBA_PIXEL_SHADER, \
            DECLARATIONS, \
            BODY)

#define MASK_MUL_CCCA_PIXEL_SHADER(DECLARATIONS, BODY) \
        MASK_PIXEL_SHADER_BUILDER( \
            TEXTURE_CCCA_PIXEL_SHADER, \
            DECLARATIONS, \
            BODY)

#define MASK_MUL_CCCC_PIXEL_SHADER(DECLARATIONS, BODY) \
        MASK_PIXEL_SHADER_BUILDER( \
            TEXTURE_CCCC_PIXEL_SHADER, \
            DECLARATIONS, \
            BODY)           

#define TRANSFORM_RGBA_PIXEL_SHADER(DECLARATION, BODY) \
    TRANSFORMED_COLOR_PIXEL_SHADER_BUILDER( \
    TEXTURE_RGBA_PIXEL_SHADER, \
    DECLARATION, \
    BODY)

#define TRANSFORMED_CCCA_PIXEL_SHADER(DECLARATION, BODY) \
    TRANSFORMED_COLOR_PIXEL_SHADER_BUILDER( \
    TEXTURE_CCCA_PIXEL_SHADER, \
    DECLARATION, \
    BODY)

#define TRANSFORMED_CCCC_PIXEL_SHADER(DECLARATION, BODY) \
    TRANSFORMED_COLOR_PIXEL_SHADER_BUILDER( \
    TEXTURE_CCCC_PIXEL_SHADER, \
    DECLARATION, \
    BODY)

#define TRANSFORMED_MASK_MUL_RGBA_PIXEL_SHADER(DECLARATION, BODY) \
    TRANSFORMED_COLOR_PIXEL_SHADER_BUILDER( \
    MASK_MUL_RGBA_PIXEL_SHADER, \
    DECLARATION, \
    BODY)

#define TRANSFORM_MASK_MUL_CCCA_PIXEL_SHADER(DECLARATION, BODY) \
    TRANSFORMED_COLOR_PIXEL_SHADER_BUILDER( \
    MASK_MUL_CCCA_PIXEL_SHADER, \
    DECLARATION, \
    BODY)

#define TRANSFORM_MASK_MUL_CCCC_PIXEL_SHADER(DECLARATION, BODY) \
    TRANSFORMED_COLOR_PIXEL_SHADER_BUILDER( \
    MASK_MUL_CCCC_PIXEL_SHADER, \
    DECLARATION, \
    BODY)

#endif // Gl2D_SHADER_DEFINITIONS_H
