//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GL_WARPING_SHADER_DEFINITION_H)
#define GL_WARPING_SHADER_DEFINITION_H


#define GL_WARPING_BUILD_SHADER(COUNT) \
        { GL_WARPING_VERTEXSHADER(COUNT, "", ""), GL_WARPING_FRAGMENTSHADER("", "") }

#define GL_WARPING_BUILD_IMX6_SIMULATION_SHADER(COUNT) \
        { GL_WARPING_VERTEXSHADER_SIMULATION(COUNT, "", ""), GL_WARPING_FRAGMENTSHADER_IMX6_SIMULATION("", "") }


#define GL_WARPING_BUILD_GENERIC_SIMULATION_SHADER(COUNT) \
                { GL_WARPING_VERTEXSHADER_SIMULATION(COUNT, "", ""), GL_WARPING_FRAGMENTSHADER_GENERIC_SIMULATION("", "") }



#ifdef CANDERA_DEVICE_EMERALD

#define GL_WARPING_SHADER(DECL, BODY) \
    "#ifndef GL_ES\n" \
    "#define mediump\n" \
    "#define precision\n" \
    "#endif\n" \
    "precision mediump float;\n" \
    DECL \
    "void main()\n" \
    "{\n" \
    BODY \
    "}\n"

#else

#define GL_WARPING_SHADER(DECL, BODY) \
            "#ifndef GL_ES\n" \
            "#define highp\n" \
            "#define mediump\n" \
            "#define precision\n" \
            "#endif\n" \
            "precision highp float;\n" \
            DECL \
            "void main()\n" \
            "{\n" \
            BODY \
            "}\n"

#endif


#define POSITION_DECL(COUNT) POSITION_DECL_##COUNT

#define POSITION_DECL_1 \
    "attribute vec4 a_Position;\n"

#define POSITION_DECL_2 \
    POSITION_DECL_1 \
    "attribute vec4 a_Position1;\n"

#define POSITION_DECL_3 \
    POSITION_DECL_2 \
    "attribute vec4 a_Position2;\n"

#define POSITION_DECL_4 \
    POSITION_DECL_3 \
    "attribute vec4 a_Position3;\n"

#define POSITION_DECL_5 \
    POSITION_DECL_4 \
    "attribute vec4 a_Position4;\n"

#define POSITION_DECL_6 \
    POSITION_DECL_5 \
    "attribute vec4 a_Position5;\n"

#define POSITION_DECL_7 \
    POSITION_DECL_6 \
    "attribute vec4 a_Position6;\n"

#define POSITION_DECL_8 \
    POSITION_DECL_7 \
    "attribute vec4 a_Position7;\n"


#define POSITION_DEF(COUNT) POSITION_DEF_##COUNT

#define POSITION_DEF_1 \
    " a_Position.xyz; \n"

#define POSITION_DEF_2 \
    "(a_Position1.xyz * u_WarpWeight[1]) + " \
    "(a_Position.xyz * u_WarpWeight[0]); \n"

#define POSITION_DEF_3 \
    "(a_Position2.xyz * u_WarpWeight[2]) + " \
    POSITION_DEF_2

#define POSITION_DEF_4 \
    "(a_Position3.xyz * u_WarpWeight[3]) + " \
    POSITION_DEF_3

#define POSITION_DEF_5 \
    "(a_Position4.xyz * u_WarpWeight[4]) + " \
    POSITION_DEF_4

#define POSITION_DEF_6 \
    "(a_Position5.xyz * u_WarpWeight[5]) + " \
    POSITION_DEF_5

#define POSITION_DEF_7 \
    "(a_Position6.xyz * u_WarpWeight[6]) + " \
    POSITION_DEF_6

#define POSITION_DEF_8 \
    "(a_Position7.xyz * u_WarpWeight[7]) + " \
    POSITION_DEF_7


// simulation
#define GL_WARPING_VERTEXSHADER_SIMULATION(COUNT, DECL, BODY) \
        GL_WARPING_SHADER( \
            "uniform mat4 mvp;\n" \
            "uniform float constantAlpha;\n" \
            "uniform vec2 influence;\n" \
            "uniform mediump float u_WarpWeight[8];\n" \
            "uniform vec4 u_Invert;\n"  \
            POSITION_DECL(COUNT) \
            "attribute vec2 a_TextureCoordinate;\n" \
            "varying vec2 vTexCoord;\n" \
            "varying float vconstantAlpha;\n" \
            "varying vec2 vinfluence;\n" \
            DECL, \
                "   vec2 textureCoordinate = u_Invert.xy * a_TextureCoordinate + u_Invert.zw;\n" \
                "   vec3 position = " \
                POSITION_DEF(COUNT) \
            BODY \
                "   gl_Position = vec4(position.xy, 0, 1) * mvp;\n" \
                "   vTexCoord.x = textureCoordinate.x;\n" \
                "   vTexCoord.y = 1.0 - textureCoordinate.y;\n" \
                "   vinfluence = influence;\n" \
                "   vconstantAlpha = constantAlpha;\n")

#define GL_WARPING_FRAGMENTSHADER_IMX6_SIMULATION(DECL, BODY) \
        GL_WARPING_SHADER( \
            "precision mediump float;\n" \
            "uniform sampler2D tex;\n" \
            "uniform sampler2D alphaMap;\n" \
            "varying float vconstantAlpha;\n" \
            "varying vec2 vinfluence;\n" \
            "varying vec2 vTexCoord;\n" \
            DECL, \
            BODY \
                "   vec4 color = texture2D(tex, vTexCoord);\n" \
                "   float pixelAlpha = texture2D(alphaMap, vTexCoord).a * vinfluence.y + (1.0 - vinfluence.y);\n" \
                "   float constAlpha = vconstantAlpha * vinfluence.x + (1.0 - vinfluence.x);\n" \
                "   gl_FragColor = vec4(color.rgb, constAlpha * pixelAlpha);\n")


#define GL_WARPING_FRAGMENTSHADER_GENERIC_SIMULATION(DECL, BODY) \
        GL_WARPING_SHADER( \
            "precision mediump float;\n" \
            "uniform sampler2D tex;\n" \
            "uniform sampler2D alphaMap;\n" \
            "varying float vconstantAlpha;\n" \
            "varying vec2 vinfluence;\n" \
            "varying vec2 vTexCoord;\n" \
            DECL, \
            BODY \
            "   vec4 color = texture2D(tex, vTexCoord);\n" \
            "   float pixelAlpha = color.a;\n" \
            "   float constAlpha = 1.0;\n" \
            "   gl_FragColor = vec4(color.rgb, constAlpha * pixelAlpha);\n")


// target
#define GL_WARPING_VERTEXSHADER(COUNT, DECL, BODY) \
        GL_WARPING_SHADER( \
            POSITION_DECL(COUNT) \
            "attribute vec2 a_TextureCoordinate;\n" \
            "uniform vec4 u_Invert;\n"  \
            "uniform mediump float u_WarpWeight[8];\n" \
            "varying vec2 v_TexCoord;\n" \
            DECL, \
                "   vec3 position = " \
                POSITION_DEF(COUNT) \
            BODY \
                "   gl_Position = vec4(position.xy * vec2(2, -2) + vec2(-1, 1), 0, 1);\n" \
                "   v_TexCoord = u_Invert.xy * a_TextureCoordinate + u_Invert.zw;\n")

#define GL_WARPING_FRAGMENTSHADER(DECL, BODY) \
        GL_WARPING_SHADER( \
            "uniform sampler2D u_Texture;\n" \
            "varying vec2 v_TexCoord;\n" \
            DECL, \
            BODY \
            "   gl_FragColor = texture2D(u_Texture, v_TexCoord);\n")

#endif //GL_WARPING_SHADER_DEFINITION_H
