//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <CanderaPlatform/Device/Common/Internal/GL/GlSimpleTextureFrameBuffer.h>
#include <CanderaPlatform/Device/Common/OpenGLES/GlTrace.h>
#include <CanderaPlatform/Device/Common/Internal/EGL/EglContext.h>
#include <CanderaPlatform/Device/Common/Base/ImageSource3D.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice.h>

namespace Candera
{

GlSimpleTextureFrameBuffer::GlSimpleTextureFrameBuffer() :
    m_colorTexture(0)
{
}

GlSimpleTextureFrameBuffer::~GlSimpleTextureFrameBuffer()
{
}

Int GlSimpleTextureFrameBuffer::GetHeight() const
{
    return m_properties.GetHeight();
}

Int GlSimpleTextureFrameBuffer::GetWidth() const
{
    return m_properties.GetWidth();
}

bool GlSimpleTextureFrameBuffer::Upload(EglContext& contextProvider, const GduSupport& /*support*/, const GlFrameBufferProperties& properties)
{
    if (m_colorTexture != 0) {
        return false;
    }

    m_properties = properties;

    bool success = contextProvider.ActivateContext();
    if (success) {
        FrameBufferColorFormat colorFormat = m_properties.GetColorFormat();
        if (colorFormat != DisabledColorFormat) {
            ImageSource3D* externalColor = m_properties.GetExternalColorTexture();
            if (externalColor == 0) {
                glGenTextures(1, &m_colorTexture);
                CANDERA_DEVICE_CHECK_AND_LOG_DEBUG(Gles, "glGenTextures");
                if (m_colorTexture == 0) {
                    return false;
                }
                glBindTexture(GL_TEXTURE_2D, m_colorTexture);
                CANDERA_DEVICE_CHECK_AND_LOG_DEBUG(Gles, "glBindTexture");
                RenderDevice::ResyncCurrentRenderStateCache(RenderDevice::ResyncActiveTextureImagesOption);
                glTexImage2D(
                    GL_TEXTURE_2D,
                    0,
                    FrameBufferColorFormatToGlesInternalFormat(colorFormat),
                    m_properties.GetWidth(),
                    m_properties.GetHeight(),
                    0,
                    FrameBufferColorFormatToGlesFormat(colorFormat),
                    FrameBufferColorFormatToGlesType(colorFormat),
                    0);
                CANDERA_DEVICE_CHECK_AND_LOG_DEBUG(Gles, "glTexImage2D");
                if (CANDERA_DEVICE_PACKAGE_TRACE_CLASS(Gles)::WasLastErrorSet()) {
                    return false;
                }
            }
            else {
                m_colorTexture = static_cast<GLuint>(externalColor->GetVideoMemoryHandle());
            }
        }
    }

    return success;
}

void GlSimpleTextureFrameBuffer::ApplyChanges(EglContext& /*contextProvider*/, const GlFrameBufferProperties& /*properties*/) const
{
}

void GlSimpleTextureFrameBuffer::SwapBuffers(EglContext& /*contextProvider*/) const
{
}

void GlSimpleTextureFrameBuffer::Unload(EglContext& contextProvider)
{
    if (contextProvider.ActivateContext()){
        if (m_colorTexture != 0) {
            glDeleteTextures(1, &m_colorTexture);
            CANDERA_DEVICE_CHECK_AND_LOG_DEBUG(Gles, "glDeleteTextures");
            m_colorTexture = 0;
            RenderDevice::ResyncCurrentRenderStateCache(RenderDevice::ResyncActiveTextureImagesOption);
        }
    }
}

Handle GlSimpleTextureFrameBuffer::GetImageHandle(Int bufferId, Int imageId) const
{
    Handle ret = 0;
    if (bufferId == 0) {
        switch(imageId) {
            case 0: ret = m_colorTexture; break;
            default: break;
        }
    }
    return ret;
}

}
