//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#include "GlFrameBufferPropertiesConvertor.h"
#include <CanderaPlatform/Device/Common/OpenGLES/GlTrace.h>
#include <CanderaPlatform/Device/Common/Internal/GL/GlFrameBufferTypes.h>
#include <CanderaPlatform/Device/Common/Internal/GL/GlFrameBufferProperties.h>
#include <CanderaPlatform/Device/Common/Internal/EGL/EglAntiAliasedWindowSurfaceProperties.h>

namespace Candera
{
    void GlConvertToFrameBufferFormatProperties(
        GlFrameBufferFormatProperties& fbProp, 
        const EglWindowSurfaceProperties &properties)
    {
        fbProp.SetColorFormat(
            RgbaToFrameBufferColorFormat(
                properties.GetRedSize(),
                properties.GetGreenSize(),
                properties.GetBlueSize(),
                properties.GetAlphaSize()));

        fbProp.SetDepthFormat(SizeToFrameBufferDepthFormat(properties.GetDepthSize()));
        fbProp.SetStencilFormat(SizeToFrameBufferStencilFormat(properties.GetStencilSize()));
    }
    void GlConvertToFrameBufferProperties(
        GlFrameBufferProperties& fbProp,
        const EglWindowSurfaceProperties &properties,
        Int width,
        Int height)
    {
        fbProp.SetWidth(width);
        fbProp.SetHeight(height);

        GlConvertToFrameBufferFormatProperties(fbProp, properties);
    }
    void GlConvertToFrameBufferProperties(
        GlFrameBufferProperties& fbProp,
        const EglAntiAliasedWindowSurfaceProperties &properties,
        Int width,
        Int height)
    {
        Float factor = 1.F;
        
        Int sampleCount = properties.GetAntiAliasingSampleBuffers();
        if (sampleCount > 1) {
            factor *= Math::SquareRoot(static_cast<Float>(sampleCount));
        }
        Int sampleFactor = properties.GetAntiAliasingMultiSamplingFactor();
        if (sampleFactor > 1) {
            factor *= Math::SquareRoot(static_cast<Float>(sampleFactor));
        }

        GLint max;
        glGetIntegerv(GL_MAX_TEXTURE_SIZE, &max);
        CANDERA_DEVICE_CHECK_AND_LOG_WARN(Gles, "glGetIntegerv");

        width = static_cast<Int>(static_cast<Float>(width) * factor);
        height = static_cast<Int>(static_cast<Float>(height) * factor);

        if (max < width){
            width = max;
        }
        if (max < height){
            height = max;
        }

        GlConvertToFrameBufferProperties(
            fbProp,
            static_cast<const EglWindowSurfaceProperties&>(properties),
            width,
            height);
    }
}
