//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(EGL_TOOLS_H)
#define EGL_TOOLS_H

#include <Candera/Environment.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageDescriptor.h>

namespace Candera
{
    class ContextResourcePool;

    namespace Internal {
/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief class holding various helper functions used in implementing GDUs.
 */
class GduTools {
public:
    /**
     * Retrieve the Context Resource Pool based on the display id.
     * It might work even when a display is not available. In this case the
     * best possible guess is made for the Context Resource Pool.
     * @param displayId Identifier of the display in the device package
     *                  interface.
     * @return The Context Resource Pool associated with the displayId, or 0
     *      if no valid context resource pool is available.
     */
    static ContextResourcePool* GetContextResourcePoolByDisplayId(Int displayId);

    /**
     * Retrieve the first context resource pool that does not contain a specific
     * Graphic device unit type. If the display forces a particular context
     * resource pool, that one is used instead.
     * @param displayId Identifier of the display in the device package
     *                  interface.
     * @param gduType   Type handle for the Graphic device unit.
     * @return A pointer to a Context Resource Pool or 0 if no valid context
     *      resource pool is available.
     */
    static ContextResourcePool* GetContextResourcePoolWithoutGdu(
        Int displayId,
        GraphicDeviceUnitTypeHandle gduType);
};

/** @}*/ //end of CommonDevice


}} // namespaces

#endif
