//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#include "GduTools.h"
#include <CanderaPlatform/Device/Common/Base/ContextResourcePool.h>
#include <CanderaPlatform/Device/Common/Base/Display.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageInterface.h>
#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnit.h>

namespace Candera {
    namespace Internal {

ContextResourcePool* GduTools::GetContextResourcePoolByDisplayId(Int displayId) 
{
    ContextResourcePool* pool = 0;
    Display* display = DevicePackageInterface::GetDisplay(displayId);
    if (display != 0) {
        pool = DisplayAccess::GetEffectiveContextResourcePool(display);
    }
    if (pool != 0) {
        return pool;
    }
    else {
        return &ContextResourcePool::GetActive();
    }
}

static ContextResourcePool *FindFreeContextResourcePool(
    GraphicDeviceUnitTypeHandle gduType);

ContextResourcePool* GduTools::GetContextResourcePoolWithoutGdu(
    Int displayId,
    GraphicDeviceUnitTypeHandle gduType)
{
    ContextResourcePool *pool = 0;
    Display* display = DevicePackageInterface::GetDisplay(displayId);
    if (display != 0) {
        pool = Internal::DisplayAccess::GetUserContextResourcePool(display);
        if (pool != 0) {
            return pool;
        }
    }
    pool = FindFreeContextResourcePool(gduType);
    if (pool != 0) {
        return pool;
    }
    if (display != 0) {
        pool = display->GetDefaultContextResourcePool();
        if (pool != 0) {
            return pool;
        }
        pool = Internal::DisplayAccess::GetFallbackContextResourcePool(display);
        if (pool != 0) {
            return pool;
        }
    }
    return &ContextResourcePool::GetActive();
}

static ContextResourcePool *FindFreeContextResourcePool(
    GraphicDeviceUnitTypeHandle gduType)
{
    for (Int i = ContextResourcePool::GetCount() - 1; i >= 0; i--) {
        ContextResourcePool *pool = ContextResourcePool::GetContextResourcePool(i);
        ContextResourcePool::ContextProviderIterator it = 
            pool->GetContextProviderIterator();
        bool isFree = true;
        while(it.IsValid()) {
            GraphicDeviceUnit* gdu = it->GetGraphicDeviceUnit();
            if ((gdu != 0) && (gdu->GetUnitType() == gduType)) {
                isFree = false;
                break;
            }
            ++it;
        }
        if (isFree) {
            return pool;
        }
    }
    return 0;
}


    }
}
