//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(EGL_EXTENSION_PROCEDURECALLDISPATCHER_H)
#define EGL_EXTENSION_PROCEDURECALLDISPATCHER_H


#include <FeatStd/Util/ConvenienceMacros.h>


namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */


/**
 * @brief Class for dispatching two argument EGL extension procedure calls with non-void Result.
 */
template<typename Argument1, typename Argument2, typename Result>
class EglExtensionProcedureCallDispatcher2
{
public:
    // Construction

    EglExtensionProcedureCallDispatcher2(const Argument1& argument1, const Argument2& argument2)
        : m_argument1(argument1), m_argument2(argument2)
    { }


    // Interface

    template<typename Implementation>
    void ApplyAndCall(Implementation implementation, EglExtensionProcedureResult<Result>& result) const {
        result = implementation(m_argument1, m_argument2);
    }


private:
    FEATSTD_MAKE_CLASS_UNCOPYABLE(EglExtensionProcedureCallDispatcher2);


    // Attrbutes

    const Argument1& m_argument1;
    const Argument2& m_argument2;
};


/**
 * @brief Partially specialized class for dispatching two argument EGL extension procedure calls with void Result.
 */
template<typename Argument1, typename Argument2>
class EglExtensionProcedureCallDispatcher2<Argument1, Argument2, /*Result*/void>
{
public:
    // Construction

    EglExtensionProcedureCallDispatcher2(const Argument1& argument1, const Argument2& argument2)
        : m_argument1(argument1), m_argument2(argument2)
    { }


    // Interface

    template<typename Implementation>
    void ApplyAndCall(Implementation implementation, EglExtensionProcedureResult<void>&) const {
        implementation(m_argument1, m_argument2);
    }


private:
    FEATSTD_MAKE_CLASS_UNCOPYABLE(EglExtensionProcedureCallDispatcher2);


    // Attrbutes

    const Argument1& m_argument1;
    const Argument2& m_argument2;
};


/**
 * @brief Class for dispatching five argument EGL extension procedure calls with non-void Result.
 */
template<typename Argument1, typename Argument2, typename Argument3,
    typename Argument4, typename Argument5, typename Result>
class EglExtensionProcedureCallDispatcher5
{
public:
    // Construction

    EglExtensionProcedureCallDispatcher5(const Argument1& argument1, const Argument2& argument2, const Argument3& argument3,
        const Argument4& argument4, const Argument5& argument5)
    : m_argument1(argument1), m_argument2(argument2), m_argument3(argument3), m_argument4(argument4), m_argument5(argument5)
    { }


    // Interface

    template<typename Implementation>
    void ApplyAndCall(Implementation implementation, EglExtensionProcedureResult<Result>& result) const
    {
        result = implementation(m_argument1, m_argument2, m_argument3, m_argument4, m_argument5);
    }


private:
    FEATSTD_MAKE_CLASS_UNCOPYABLE(EglExtensionProcedureCallDispatcher5);


    // Attrbutes

    const Argument1& m_argument1;
    const Argument2& m_argument2;
    const Argument3& m_argument3;
    const Argument4& m_argument4;
    const Argument5& m_argument5;
};


/** @}*/ //end of CommonDevice

} // namespace Candera


#endif // defined(EGL_EXTENSION_PROCEDURECALLDISPATCHER_H)
