//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(EGL_EXTENSION_H)
#define EGL_EXTENSION_H


#include <CanderaPlatform/Device/Common/EGL/EglInclude.h>
#include <CanderaPlatform/Device/Common/EGL/EglTraceMapper.h>


namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */


/**
 * @brief Class providing querying support for EGL extensions.
 */

class EglExtension
{
    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaPlatformDevice);


private:
    // Types

    enum SupportStatus {
        SupportNotQueriedYet = 0,
        Supported,
        NotSupported
    };


public:
    // Construction

    EglExtension(const FeatStd::Char* name)
    :   m_name(name),
        m_support(SupportNotQueriedYet)
    { }


    // Accessors

    const FeatStd::Char* GetName() const { return m_name; }

    bool IsSupported();


private:
    // Attributes

    const FeatStd::Char* m_name;
    SupportStatus m_support;
};


/** @}*/ //end of CommonDevice

} // namespace Candera


#endif // defined(EGL_EXTENSION_H)
