//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(EGL_WINDOW_SURFACE_PROPERTIES_H)
#define EGL_WINDOW_SURFACE_PROPERTIES_H

#include <CanderaPlatform/Device/Common/Internal/EGL/EglSurfaceProperties.h>

namespace Candera
{
/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief EglWindowSurfaceProperties exposes the properties of an EGL window surface.
 *
 * EglWindowSurfaceProperties extends EglSurfaceProperties and exposes additional
 * swapping related properties.
 */
class EglWindowSurfaceProperties : public EglSurfaceProperties
{
    public:
        /**
         * Constructor
         */
        EglWindowSurfaceProperties() : m_swapInterval(1) {}

        // Properties ----------------------------------------------------------------------------------------
        void SetMaxSwapInterval(Int value) { m_eglConfig.SetConfigurationAttribute(EglConfiguration::EglMaxSwapInterval, value); }
        Int GetMaxSwapInterval() const { return m_eglConfig.GetConfigurationAttribute(EglConfiguration::EglMaxSwapInterval); }

        void SetMinSwapInterval(Int value) { m_eglConfig.SetConfigurationAttribute(EglConfiguration::EglMinSwapInterval, value); }
        Int GetMinSwapInterval() const { return m_eglConfig.GetConfigurationAttribute(EglConfiguration::EglMinSwapInterval); }

        void SetSwapInterval(Int value) { m_swapInterval = value; }
        Int GetSwapInterval() const { return m_swapInterval; }

        /// @cond excluded from doxygen
        CdaForeignGduDef(EglWindowSurfaceProperties)
            CdaGduProperties()
                // EGL Properties
                CdaGduProperty(MaxSwapInterval, Int, GetMaxSwapInterval, SetMaxSwapInterval)
                    CdaDescription("Maximum swap interval. Used to choose the EGL configuration.")
                CdaGduPropertyEnd()

                CdaGduProperty(MinSwapInterval, Int, GetMinSwapInterval, SetMinSwapInterval)
                    CdaDescription("Minimum swap interval. Used to choose the EGL configuration.")
                CdaGduPropertyEnd()

                CdaGduProperty(SwapInterval, Int, GetSwapInterval, SetSwapInterval)
                    CdaDescription("Swap interval. Value set to the window surface. "
                                   "See eglSwapInterval for more detail.")
                    CdaUpdateType(OnApplyUpdateType)
                CdaGduPropertyEnd()

                CdaGduImportBaseClassProperties(EglSurfaceProperties, Candera::EglSurfaceProperties)

            CdaGduPropertiesEnd()
        CdaGduDefEnd()
        /// @endcond

    private:
        Int m_swapInterval;
};

/** @}*/ //end of CommonDevice
}

#endif //EGL_WINDOW_SURFACE_PROPERTIES_H
