//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(EGL_SURFACE_PROPERTIES_H)
#define EGL_SURFACE_PROPERTIES_H

#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnitMetaInfo.h>
#include <CanderaPlatform/Device/Common/EGL/EglConfiguration.h>

#include <CanderaPlatform/Device/Common/Internal/GDU/GduProperties.h>

namespace Candera
{
/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief EglSurfaceProperties exposes the properties of an EGL surface.
 */
class EglSurfaceProperties : public GduProperties
{
    public:
        /**
         * Constructor
         */
        EglSurfaceProperties() {}

        EglConfiguration& GetConfiguration() { return m_eglConfig; }
        const EglConfiguration& GetConfiguration() const { return m_eglConfig; }

        // Properties ----------------------------------------------------------------------------------------
        void SetRedSize(Int value) { m_eglConfig.SetConfigurationAttribute(EglConfiguration::EglRedSize, value); }
        Int GetRedSize() const { return m_eglConfig.GetConfigurationAttribute(EglConfiguration::EglRedSize); }

        void SetGreenSize(Int value) { m_eglConfig.SetConfigurationAttribute(EglConfiguration::EglGreenSize, value); }
        Int GetGreenSize() const { return m_eglConfig.GetConfigurationAttribute(EglConfiguration::EglGreenSize); }

        void SetBlueSize(Int value) { m_eglConfig.SetConfigurationAttribute(EglConfiguration::EglBlueSize, value); }
        Int GetBlueSize() const { return m_eglConfig.GetConfigurationAttribute(EglConfiguration::EglBlueSize); }

        void SetAlphaSize(Int value) { m_eglConfig.SetConfigurationAttribute(EglConfiguration::EglAlphaSize, value); }
        Int GetAlphaSize() const { return m_eglConfig.GetConfigurationAttribute(EglConfiguration::EglAlphaSize); }

        void SetConformant(bool value) { m_eglConfig.SetConfigurationAttribute(EglConfiguration::EglConformant, value ? EglConfiguration::EglConformantOpenGlEs2Bit : 0); }
        bool IsConformant() const { return (m_eglConfig.GetConfigurationAttribute(EglConfiguration::EglConformant) & EglConfiguration::EglConformantOpenGlEs2Bit) > 0; }

        void SetDepthSize(Int value) { m_eglConfig.SetConfigurationAttribute(EglConfiguration::EglDepthSize, value); }
        Int GetDepthSize() const { return m_eglConfig.GetConfigurationAttribute(EglConfiguration::EglDepthSize); }

        void SetStencilSize(Int value) { m_eglConfig.SetConfigurationAttribute(EglConfiguration::EglStencilSize, value); }
        Int GetStencilSize() const { return m_eglConfig.GetConfigurationAttribute(EglConfiguration::EglStencilSize); }

        /// @cond excluded from doxygen
        CdaForeignGduDef(EglSurfaceProperties)
            CdaGduProperties()

                CdaGduImportBaseClassProperties(GduProperties, Candera::GduProperties)

                // EGL Properties
                CdaGduProperty(RedSize, Int, GetRedSize, SetRedSize)
                    CdaDescription("bits of Red in the color buffer")
                CdaGduPropertyEnd()

                CdaGduProperty(GreenSize, Int, GetGreenSize, SetGreenSize)
                    CdaDescription("bits of Green in the color buffer")
                CdaGduPropertyEnd()

                CdaGduProperty(BlueSize, Int, GetBlueSize, SetBlueSize)
                    CdaDescription("bits of Blue in the color buffer")
                CdaGduPropertyEnd()

                CdaGduProperty(AlphaSize, Int, GetAlphaSize, SetAlphaSize)
                    CdaDescription("bits of Alpha in the color buffer")
                CdaGduPropertyEnd()

                CdaGduProperty(Conformant, bool, IsConformant, SetConformant)
                    CdaDescription("Indicates whether this object is Open GL ES conformant")
                CdaGduPropertyEnd()

                CdaGduProperty(DepthSize, Int, GetDepthSize, SetDepthSize)
                    CdaDescription("Bits of Z in the depth buffer")
                CdaGduPropertyEnd()

                CdaGduProperty(StencilSize, Int, GetStencilSize, SetStencilSize)
                    CdaDescription("bits of Stencil in the stencil buffer")
                CdaGduPropertyEnd()

            CdaGduPropertiesEnd()
        CdaGduDefEnd()
        /// @endcond

    protected:
        EglConfiguration m_eglConfig;
};

/** @}*/ //end of CommonDevice
}

#endif
