//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <FeatStd/Util/StaticObject.h>
#include "EglGenericContextProviderPool.h"
#include <CanderaPlatform/Device/Common/Base/Display.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageInterface.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageTrace.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduTools.h>

namespace Candera
{

const EglGenericContextProvider* EglGenericContextProviderPool::Get(Int index)
{
    ContextResourcePool* pool = 
        Internal::GduTools::GetContextResourcePoolByDisplayId(index);
    if (pool == 0) {
        CANDERA_DEVICE_LOG_WARN("no context resource pool");
        return 0;
    }

    if (GetPool()[pool->GetIndex()].IsComplete()) {
        return &GetPool()[pool->GetIndex()];
    }

    return 0;
}

EglGenericContextProvider* EglGenericContextProviderPool::GetByPool(Int index)
{
    if ((index >= 0) && (index < CANDERA_MAX_CONTEXT_COUNT)) {
        // Allow incomplete context providers.
        return &GetPool()[index];
    }
    return 0;
}

void EglGenericContextProviderPool::Attach(
    ContextResourcePool& pool, 
    EGLDisplay display, 
    EGLConfig config, 
    EGLSurface readSurface, 
    EGLSurface drawSurface, 
    EGLContext context)
{
    GetPool()[pool.GetIndex()].Attach(&pool, display, config, readSurface, drawSurface, context);
}

void EglGenericContextProviderPool::Detach(const EglGenericContextProvider* provider)
{
    // Must go over the array because == and != are the only operators
    // that are guaranteed by the standard to return the correct result
    // for a generic pointer "provider"
    for (Int index = 0; index < CANDERA_MAX_CONTEXT_COUNT; index ++){
        if (provider == &GetPool()[index]) {
            GetPool()[index].DetachAll();
            break;
        }
    }
}

EglGenericContextProviderPool::Pool& EglGenericContextProviderPool::GetPool()
{
    // MSVC placement new array operator behaves quite strange - thus 
    // we need to package the Pool array in a structure (StaticObject
    // disallows arrays).
    FEATSTD_UNSYNCED_STATIC_OBJECT(PoolContainer, s_poolContainer);
    return s_poolContainer.mPool;
}

}

