//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "EglContextDelegator.h"
#include <CanderaPlatform/Device/Common/Base/DevicePackageTrace.h>

#include <CanderaPlatform/Device/Common/Base/DevicePackageInterface.h>
#include <CanderaPlatform/Device/Common/Base/Display.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduTools.h>

namespace Candera
{

EglContextDelegator::~EglContextDelegator()
{
    m_mustReleasePool = true;
    Unload();
}

bool EglContextDelegator::Activate()
{
    return ContextDelegator3D::ActivateContext();
}

bool EglContextDelegator::Upload(Int displayId, GduSupport& /*support*/, GduProperties& /*properties*/)
{
    ContextResourcePool* pool = GetContextResourcePool();
    if (pool == 0) {
        pool = Internal::GduTools::GetContextResourcePoolByDisplayId(displayId);
        m_mustReleasePool = true;
    }

    if (pool == 0) {
        CANDERA_DEVICE_LOG_WARN("incorrect context resource pool");
        return false;
    }

    SetContextResourcePool(pool);

    return true;
}

void EglContextDelegator::Unload()
{
    if (m_mustReleasePool) {
        m_mustReleasePool = false;
        SetContextResourcePool(0);
    }
}

void EglContextDelegator::ApplyChanges(GduProperties& /*properties*/) const
{
}

}

