//########################################################################
// (C)  Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !(defined EGL_CONTEXT_CREATOR_LISTENER_COLLECTION_H)
#define EGL_CONTEXT_CREATOR_LISTENER_COLLECTION_H

#include <CanderaPlatform/Device/Common/Base/Surface.h>

#include <Candera/EngineBase/Common/ListenerContainer.h>
#include <FeatStd/Event/EventListener.h>
#include <FeatStd/Event/Event.h>
#include <FeatStd/Event/EventSource.h>

namespace Candera {

        class EglContextCreatorEventListenerCollection
        {
        public:
            enum EventTypes
            {
                AfterUpload,
                BeforeUnload
            };

            void AddEventListener(FeatStd::EventListener* listener)
            {
                if (!m_listenerContainer.Contains(listener)) {
                    static_cast<void>(m_listenerContainer.Add(listener));
                }
            }
            void RemoveEventListener(FeatStd::EventListener* listener)
            {
                static_cast<void>(m_listenerContainer.Remove(listener));
            }

            class EventBase : public FeatStd::Event
            {
            public:
                FEATSTD_RTTI_TEMPLATE_DEFINITION(EventBase, FeatStd::Event);
                virtual ~EventBase() {}
                EGLContext GetEglContext() const { return m_eglContext; }
                EGLContext GetSharedContext() const { return m_sharedContext; }

            protected:
                EventBase(const EGLContext eglContext, const EGLContext sharedContext) :m_eglContext(eglContext), m_sharedContext(sharedContext) { }

            private:
                const EGLContext m_eglContext;
                const EGLContext m_sharedContext;
            };

            template <EventTypes EventType>
            class TEvent : public EventBase
            {
            public:
                FEATSTD_RTTI_TEMPLATE_DEFINITION(TEvent, EventBase);
                TEvent(const EGLContext eglContext, const EGLContext sharedContext) :EventBase(eglContext, sharedContext) { }
            };

            template <EventTypes EventType>
            class ListenerContainerEvent : public Candera::Internal::ListenerContainer<FeatStd::EventListener>::Event
            {
                typedef TEvent<EventType> Event;
            public:
                ListenerContainerEvent(const EGLContext eglContext, const EGLContext sharedContext) :m_event(eglContext, sharedContext) { }
                virtual void Notify(FeatStd::EventListener* listener) override { static_cast<void>(listener->OnEvent(m_event)); }

            private:
                Event m_event;
            };

            template <EventTypes EventType>
            void NotifyListeners(const EGLContext  eglContext, const EGLContext sharedContext)
            {
                ListenerContainerEvent<EventType> event(eglContext, sharedContext);
                m_listenerContainer.Iterate(event);
            }
        private:

            typedef Internal::ListenerContainer<FeatStd::EventListener> ListenerContainer;
            ListenerContainer m_listenerContainer;
        };

}   // namespace Candera


#endif // EGL_CONTEXT_CREATOR_LISTENER_COLLECTION_H
