//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(EGL_CONTEXT_CREATOR_H)
#define EGL_CONTEXT_CREATOR_H

#include <Candera/Environment.h>

#include <CanderaPlatform/Device/Common/Internal/EGL/EglChain.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduSupport.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduProperties.h>

#include <CanderaPlatform/Device/Common/EGL/EglInclude.h>

#include <CanderaPlatform/Device/Common/Internal/EGL/EglContextCreatorEventListenerCollection.h>
#include <FeatStd/Util/StaticObject.h>

namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief EglContextCreator is a class that handles EGL context creation.
 *
 * This class is a proper base for a surface provider, that should complete the EglChain.
 * It also requires a Shared context that may be provided by an EglContextProvider.
 */

class EglContextCreator : public EglChain
{
    CANDERA_LINT_DECLARE_CLEANUP_FUNCTION(Candera::EglContextCreator::Unload)

    public:

        typedef EglContextCreatorEventListenerCollection::TEvent<EglContextCreatorEventListenerCollection::AfterUpload> AfterUploadEvent;
        typedef EglContextCreatorEventListenerCollection::TEvent<EglContextCreatorEventListenerCollection::BeforeUnload> BeforeUnloadEvent;

        /**
         *  Constructs an EglContextCreator object.
         */
        EglContextCreator();

        /**
         *  Destructs an EglContextCreator object.
         */
        ~EglContextCreator() {}

        /**
         *  Retrieves the associated context. Overloads virtual method from EglChain.
         *  @return handle of the associated EGLContext.
         */
        virtual EGLContext GetContext() const { return m_context; }

        /**
        *  Retrieves a reference to the EventSource for this class
        *  @return reference to the EventSource 
        */
        static FeatStd::EventSource& GetEventSource()
        {
            FEATSTD_UNSYNCED_STATIC_OBJECT(FeatStd::EventSource, s_eventSource);
            return s_eventSource;
        }


    protected:

        /**
         *  Creates the associated Context.
         *  @return True if successful, false otherwise.
         */
        bool Upload(Int = 0, const GduSupport& = GduSupport(), const GduProperties& = GduProperties());

        /**
         *  Destroys the associated Context.
         */
        void Unload();

        /**
         *  Retrieves the base context used for resource sharing.
         *  @return handle of the shared EGLContext.
         */
        virtual EGLContext GetShareContext() const;

    private:
        EGLContext m_context;
};

/** @}*/ //end of CommonDevice

}

#endif
