//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GRAPHICS_WINDOW_H)
#define GRAPHICS_WINDOW_H

#include <CanderaPlatform/Device/Common/Base/Window.h>
#include <CanderaPlatform/Device/Common/Graphics/GraphicsProperties.h>

namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */

CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1511, Candera::GraphicsWindow::Upload, CANDERA_LINT_REASON_EXPLICITHIDING)
CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1511, Candera::GraphicsWindow::Unload, CANDERA_LINT_REASON_EXPLICITHIDING)
CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1511, Candera::GraphicsWindow::ApplyChanges, CANDERA_LINT_REASON_EXPLICITHIDING)

/**
 * @brief GraphicsWindow is the base class of support objects as required by GraphicsRenderTarget.
 *
 * It defines the basic interface required by such objects.
 */
class GraphicsWindow : public Window
{
    public:

    /**
     *  Returns 0, as no info is present. Override of function from Window.
     *  @return     0 to signify that Size is unavailable.
     */
    virtual Int GetHeight() const { return 0; }

    /** For internal compatibility */
    virtual Int GetMsaaHeight() const { return GetHeight(); }

    /**
     *  Returns 0, as no info is present. Override of function from Window.
     *  @return     0 to signify that Size is unavailable.
     */
    virtual Int GetWidth() const { return 0; }

    /** For internal compatibility */
    virtual Int GetMsaaWidth() const { return GetWidth(); }

    /**
     *  Returns 0, as no info is present. Override of function from Window.
     *  @return     0 to signify that Position is unavailable.
     */
    virtual Int GetX() const { return 0; }

    /**
     *  Returns 0, as no info is present. Override of function from Window.
     *  @return     0 to signify that Position is unavailable.
     */
    virtual Int GetY() const { return 0; }

    /**
     * Destructor
     */
    virtual ~GraphicsWindow() {}

    /**
     * Does nothing.
     * @param displayId Unused.
     * @param properties Unused.
     * @return True.
     */
    bool Upload(Int /*displayId*/, const GraphicsProperties& /*properties*/) { return true; }

    /**
     * Does nothing.
     */
    void Unload() {}

    /**
     * Does nothing.
     * @param properties Unused.
     */
    void ApplyChanges(const GraphicsProperties& /*properties*/) {}

};

/** @}*/ //end of CommonDevice

}

#endif //GRAPHICS_WINDOW_H
