//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GRAPHICS_CONTEXT_H)
#define GRAPHICS_CONTEXT_H

#include <Candera/Environment.h>

namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */

class GraphicsWindow;
class GraphicsProperties;

/**
 * @brief GraphicsContent is an interface implemented by context providers.
 */

class GraphicsContent
{
    public:
        /**
         *  Activate the associated context.
         *  @return true if activation is successful
         */
        virtual bool ActivateContext() = 0;

        /**
         *  Does nothing. Required by GraphicsRenderTarget.
         *  @param displayId        Unused.
         *  @param support          Unused.
         *  @param properties       Unused.
         *  @return True.
         */
        bool Upload(Int displayId, GraphicsWindow& support, GraphicsProperties& properties);


        /**
         *  Does nothing. Required by GraphicsRenderTarget.
         *  @param properties       Unused.
         */
        void ApplyChanges(GraphicsProperties& properties);


        /**
         *  Does nothing. Required by GraphicsRenderTarget.
         */
        void Unload();

        virtual void *GetContextHandle() const { return static_cast<void*>(0); }

    protected:

        /**
         *  Non-virtual. An object should never be destroyed from a pointer to this class.
         */
        ~GraphicsContent() {}
};

/** @}*/ //end of CommonDevice

inline bool GraphicsContent::Upload(Int /*displayId*/, GraphicsWindow& /*support*/, GraphicsProperties& /*properties*/)
{
    return true;
}
inline void GraphicsContent::ApplyChanges(GraphicsProperties& /*properties*/)
{
}
inline void GraphicsContent::Unload()
{
}

}

#endif //GRAPHICS_CONTEXT_H
