//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TEXT_BRUSH_CACHE_TYPE_PROPERTY_H)
    #define CANDERA_TEXT_BRUSH_CACHE_TYPE_PROPERTY_H

#include <Candera/Environment.h>
#include <Candera/Engine2D/Property/Property.h>
#include <Candera/Engine2D/Property/ColorProperty.h>
#include <Candera/Engine2D/Property/FontProperty.h>
#include <Candera/Engine2D/Property/StyleProperty.h>
#include <Candera/Engine2D/Property/Vector2Property.h>
#include <Candera/TextEngine/PreprocessingContext.h>
#include <Candera/System/GlobalizationBase/Culture.h>

#ifdef CANDERA_2D_OVER_3D_ENABLED
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(TextBrushCacheType)    \
        ENUM_DATA_TYPE_ITEM(NoCache)            \
        ENUM_DATA_TYPE_ITEM(GlyphCache)         \
        ENUM_DATA_TYPE_ITEM(BitmapCache)        \
        ENUM_DATA_TYPE_ITEM(SurfaceCache)       \
        ENUM_DATA_TYPE_ITEM(GlyphAtlasCache)    \
    ENUM_DATA_TYPE_END(TextBrushCacheType)
#else
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(TextBrushCacheType)    \
        ENUM_DATA_TYPE_ITEM(NoCache)            \
        ENUM_DATA_TYPE_ITEM(GlyphCache)         \
        ENUM_DATA_TYPE_ITEM(BitmapCache)        \
        ENUM_DATA_TYPE_ITEM(SurfaceCache)       \
    ENUM_DATA_TYPE_END(TextBrushCacheType)
#endif


#include <Candera/System/MetaInfo/EnumDataType.h>

#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(TextBrushAlignment)            \
        ENUM_DATA_TYPE_ITEM(TextBrushConstantHeight)    \
        ENUM_DATA_TYPE_ITEM(TextBrushActualHeight)      \
    ENUM_DATA_TYPE_END(TextBrushAlignment)

#include <Candera/System/MetaInfo/EnumDataType.h>

#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(TextBrushComplexScriptMode)            \
        ENUM_DATA_TYPE_ITEM(TextBrushComplexScriptDisabled)     \
        ENUM_DATA_TYPE_ITEM(TextBrushArabicScript)              \
    ENUM_DATA_TYPE_END(TextBrushComplexScriptMode)

#include <Candera/System/MetaInfo/EnumDataType.h>

#include <Candera/TextEngine/TextEngine.h>

namespace Candera {
    namespace TextRendering {
        class TextLayoutStrategy;
    }
    typedef SimplePropertyEx<TextBrushCacheType> TextBrushCacheTypePropertyEx;
    typedef SimplePropertyEx<TextBrushAlignment> TextBrushAlignmentPropertyEx;
    typedef SimplePropertyEx<TextBrushComplexScriptMode> TextBrushComplexScriptModePropertyEx;
    typedef SimplePropertyEx<Globalization::Culture::SharedPointer> CulturePropertyEx;
    typedef SimplePropertyEx<HorizontalAlignment> HorizontalAlignmentPropertyEx;
    typedef SimplePropertyEx<VerticalAlignment> VerticalAlignmentPropertyEx;
    typedef SimplePropertyEx<bool> BoolPropertyEx;
    typedef SimplePropertyEx<TextRendering::TextLayoutStrategy*> TextLayoutStrategyPropertyEx;
    typedef SimplePropertyEx<TextRendering::PreprocessingContext::Iterator> PreprocessedTextPropertyEx;
    typedef SimplePropertyEx<UInt16> UInt16PropertyEx;

    namespace Internal {
        /**
        * Structure containing properties of a TextBrush.
        *
        * @see TextBrush
        */
        struct TextBrushProperties {
            TextBrushComplexScriptModePropertyEx m_complexScriptMode;
            TextBrushCacheTypePropertyEx m_cacheType;
            TextPropertyEx m_text;
            StylePropertyEx m_style;
            UInt16PropertyEx m_currentStyleVersion;
            CulturePropertyEx m_culture;
            Vector2PropertyEx m_layoutingArea;
            Vector2PropertyEx m_cacheArea;
            ColorProperty m_color;
            HorizontalAlignmentPropertyEx m_horizontalAlignment;
            VerticalAlignmentPropertyEx m_verticalAlignment;
            FloatPropertyEx m_glyphSpacing;
            FloatPropertyEx m_lineSpacing;
            BoolPropertyEx m_pixelwiseLineSpacing;
            BoolPropertyEx m_multiLineLayouting;
            BoolPropertyEx m_wordWrap;
            TextLayoutStrategyPropertyEx m_layoutStrategy;
            PreprocessedTextPropertyEx m_preprocessedText;

            TextBrushProperties();
            TextBrushProperties(const TextBrushProperties& rhs);

            TextRendering::PixelSize GetLineSpacing() const;
            TextRendering::LayoutingOptions GetLayoutingOptions() const;
            TextRendering::ShapingOptions GetShapingOptions() const;
            TextRendering::TextProperties GetTextProperties() const;
        };
    }   // namespace Internal
}   // namespace Candera

#endif  // CANDERA_TEXT_BRUSH_CACHE_TYPE_PROPERTY_H
