//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TEXT_BRUSH_CACHE_H)
    #define CANDERA_TEXT_BRUSH_CACHE_H

#include <Candera/Environment.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>
#include <Candera/System/Rtti/Rtti.h>
#include <CanderaPlatform/Device/Common/Effects/TextBrushProperties.h>

namespace Candera {

    namespace TextRendering {
        class Style;
    }


    namespace Internal {
         /**
         *  @brief Interface for the caching mechanism used in TextBrush.
         */
        class TextBrushCache {
            public:
                FEATSTD_RTTI_DECLARATION();

                /**
                 * Destructor
                 */
                virtual ~TextBrushCache() {}

                /**
                 *  Update the cache as required to handle the new properties.
                 *  @param textBrushProperties     The text brush properties.
                 *  @param textRect                 The text rectangle.
                 *  @return True if successful, false otherwise.
                 */
                virtual bool Update(const TextBrushProperties& textBrushProperties, const Rectangle& textRect) = 0;

                /**
                 *  Render text.
                 *  @param textBrushProperties      The text brush properties.
                 *  @param transform                3x2 transform matrix
                 *  @param bound                    The bounding rectangle of the brush.
                 *  @param output                   The ContextHandle2D output
                 *  @param outputArea               The output Area as a rectangle
                 */
                virtual void Render(const TextBrushProperties& textBrushProperties, const Matrix3x2& transform, const Rectangle& bound, ContextHandle2D output, Rectangle& outputArea) = 0;

                /**
                 *  Determines whether the text area has to be clear by the text brush or not.
                 *  @return True if the text area has to be clear by the text brush, false otherwise.
                 */
                virtual bool IsGlyphByGlyph() = 0;
                
                /**
                 *  The text render context used by this caching strategy.
                 *  This may not be used for rendering text, only for measurements.
                 *  @return The underlying TextRenderContext.
                 */
                virtual const TextRendering::TextRenderContext* GetTextRenderContext() const { return 0; }

                /**
                 * Do necessary resources unload on client node unload
                 */
                virtual void Unload() {}

                /**
                 * Do necessary resources upload on client node upload
                 */
                virtual void Upload() {}
        };
    }   // namespace Internal

}   // namespace Candera

#endif  // CANDERA_TEXT_BRUSH_CACHE_H
