//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SURFACE_TEXT_RENDER_CONTEXT_H)
    #define CANDERA_SURFACE_TEXT_RENDER_CONTEXT_H

#include <Candera/Environment.h>
#include <Candera/TextEngine/TextEngine.h>
#include <Candera/System/Mathematics/Matrix3x2.h>
#include <Candera/System/Mathematics/Rectangle.h>

namespace Candera {

    /**
     *  @brief  SurfaceTextRenderContext class
     *          @see Candera::TextRendering::TextRenderContext
     */
    class SurfaceTextRenderContext : public TextRendering::TextRenderContext {
    public:
        /**
         *  Constructor
         */
        SurfaceTextRenderContext();

        /**
         *  Sets the context2D handle.
         *  @param context2D The context2D handle that is set.
         */
        void Set2DContext(Handle context2D);

        /**
         *  Retrieves the current clip rectangle.
         *  @return The current text rectangle.
         */
        virtual const TextRendering::TextRect& GetClipRect() const;

        /** 
         *  Blit the given glyph bitmap to the specified position in the render target
         *  @param x     left coordinate of the glyph bitmap
         *  @param y     top coordinate of the glyph bitmap
         *  @param glyph the glyph bitmap to be blitted
         *  @see TextRenderContext::Blit 
         */
        virtual void Blit(Int16 x, Int16 y, const TextRendering::GlyphBitmap &glyph);
        
        /**
         *  Returns if context requires cached access to glyphs.
         *  @return True if context requires cached access to glyphs.
         */
        virtual bool IsCachingEnabled() const { return false; }

        /**
         *  Sets the transformation matrix.
         *  @param trans The transformation matrix that is set.
         */
        void SetTransformation(const Matrix3x2& trans) { m_transformation = trans; }

        /**
         *  Resets the updated area.
         */
        void ResetUpdatedArea() { m_updatedArea = Rectangle(); }

        /**
         *  Retrieves the updated area, this returned property
         *  can be changed. The performed changes will affect this class.
         *  @return The updated area as a rectangle.
         */
        const Rectangle& GetUpdatedArea() const { return m_updatedArea;}
    private:
        Handle m_context;
        Rectangle m_updatedArea;
        Matrix3x2 m_transformation;
        
        mutable TextRendering::TextRect m_clip;
    };

}   // namespace Candera

#endif  // CANDERA_SURFACE_TEXT_RENDER_CONTEXT_H
