//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_NO_TEXT_BRUSH_CACHE_H)
    #define CANDERA_NO_TEXT_BRUSH_CACHE_H

#include <CanderaPlatform/Device/Common/Effects/TextBrushCache/TextBrushCache.h>
#include <CanderaPlatform/Device/Common/Effects/TextBrushCache/SurfaceTextRenderContext.h>

namespace Candera {

    class Image2D;

    namespace Internal {
        /**
         *  @brief  This is a replacement for the TextBrushCache, that renders text
         *          without cachig any state.
         *          @see Candera::TextRendering::TextRenderContext
         */
        class NoTextBrushCache : public TextBrushCache {

            FEATSTD_TYPEDEF_BASE(TextBrushCache);

            public:

                FEATSTD_RTTI_DECLARATION();

                /**
                 *  Constructor
                 */
                NoTextBrushCache();

                /**
                 *  Destructor
                 */
                virtual ~NoTextBrushCache();

                // Overrides method from TextBrushCache.
                virtual bool Update(const TextBrushProperties& /*textBrushProperties*/, const Rectangle& /*textRect*/) { return true; }
                // Overrides method from TextBrushCache.
                virtual void Render(const TextBrushProperties& textBrushProperties, const Matrix3x2& transform, const Rectangle& bound, ContextHandle2D output, Rectangle& outputArea);
                // Overrides method from TextBrushCache.
                virtual bool IsGlyphByGlyph() { return true; }

            private:
                SurfaceTextRenderContext m_context;
        };
    }   // namespace Internal
}   // namespace Candera

#endif  // CANDERA_NO_TEXT_BRUSH_CACHE_H
