//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "NoTextBrushCache.h"

namespace Candera {
    namespace Internal {

        FEATSTD_RTTI_DEFINITION(NoTextBrushCache, TextBrushCache)

        /******************************************************************************
         *  Constructor
         ******************************************************************************/
        NoTextBrushCache::NoTextBrushCache()
        {
        }

        /******************************************************************************
         *  Destructor
         ******************************************************************************/
        NoTextBrushCache::~NoTextBrushCache()
        {
        }

        /******************************************************************************
         *  Render
         ******************************************************************************/
        void NoTextBrushCache::Render(const TextBrushProperties& textBrushProperties, const Matrix3x2& transform, const Rectangle& /*bound*/, ContextHandle2D output, Rectangle& outputArea)
        {
            if ((!textBrushProperties.m_style().PointsToNull()) && (textBrushProperties.m_text() != 0)) {
                m_context.Set2DContext(output);
                m_context.SetTransformation(transform);

                m_context.ResetUpdatedArea();

                static_cast<void>(TextRendering::TextRenderer().Render(
                    m_context, 
                    textBrushProperties.GetLayoutingOptions(),
                    textBrushProperties.GetShapingOptions(),
                    textBrushProperties.GetTextProperties()));

                outputArea = m_context.GetUpdatedArea();
            }
        }
    }   // namespace Internal
}   // namespace Candera
