//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TEXT_BRUSH_BLEND_H)
    #define CANDERA_TEXT_BRUSH_BLEND_H

#include <Candera/Engine2D/Effects/CombinedEffect2D.h>
#include <CanderaPlatform/Device/Common/Effects/TextBrush.h>
#include <CanderaPlatform/Device/Common/Effects/BlendEffect.h>

namespace Candera {

    /**
     *  @brief  Output alpha only glyph data and blend it with the store buffer.
     *          Same as chaining (TextBrush + BlendEffect)
     *          @see Candera::TextBrush
     *          @see Candera::BlendEffect
     */
    class TextBrushBlend : public CombinedEffect2D {

        FEATSTD_TYPEDEF_BASE(CombinedEffect2D);

        public:
            typedef MemoryManagement::SharedPointer<TextBrushBlend> SharedPointer;

            FEATSTD_RTTI_DECLARATION();

            /**
             *  Creates an instance of this class
             *  @return A pointer to the created object.
             */
            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            /**
             *  Destructor
             */
            virtual ~TextBrushBlend();

            /**
             *  Retrieves the text brush.
             *  @return     The text brush.
             */
            const TextBrush& GetTextBrush() const { return m_textBrush; }
            TextBrush& GetTextBrush() { return m_textBrush; }

            /**
             *  Retrieves the blend effect.
             *  @return     The blend effect.
             */
            const BlendEffect& GetBlendEffect() const { return m_blendEffect; }
            BlendEffect& GetBlendEffect() { return m_blendEffect; }

            // overrides Effect2D::GetBrushEffect2D
            virtual BrushEffect2D* GetBrushEffect2D() { return &m_textBrush; }

            // overrides Effect2D::GetBlendEffect2D
            virtual BlendEffect2D* GetBlendEffect2D() { return &m_blendEffect; }

            // overrides Effect2D::Upload
            virtual bool Upload();

            // overrides Effect2D::Unload
            virtual bool Unload();

            // overrides Effect2D::Update
            virtual bool Update();

            // overrides Effect2D::Clone
            virtual Effect2D::SharedPointer Clone() const;

            /// @cond excluded from doxygen
            CdaEffect2DCombinedDef(Candera::TextBrushBlend, TextBrushBlend, EFFECT2D_TYPE_BRUSH, EFFECT2D_TYPE_BLEND)
                CdaDeprecated()
                CdaEffect2DProperties()

                    CdaEffect2DImportProperties(TextBrush, Candera::TextBrush, m_textBrush)
                    CdaEffect2DImportProperties(BlendEffect, Candera::BlendEffect, m_blendEffect)

                CdaEffect2DPropertiesEnd()
            CdaEffect2DDefEnd()
            /// @endcond

        protected:
            // Explicit protected Constructor and Copy-Constructor, use Create() to create an instance of this object.
            TextBrushBlend();
            explicit TextBrushBlend(const TextBrushBlend& rhs);
            TextBrushBlend& operator = (const TextBrushBlend& rhs);

            // overrides Effect2D::Render
            virtual void Render(SurfaceHandle input, const Rectangle& inputArea, const Matrix3x2& transform, const Node2D& node, ContextHandle2D output, Rectangle& outputArea);

        private:
            // Use class wrapper to forward protected members.
            class TextBrushWrapper : public TextBrush {} m_textBrush;
            class BlendEffectWrapper : public BlendEffect {} m_blendEffect;
    };

}   // namespace Candera

#endif  // CANDERA_TEXT_BRUSH_BLEND_H
