//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "SolidColorBrushBlend.h"
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <Candera/System/Monitor/PerfMonPublicIF.h>
#include <Candera/Engine2D/Core/Camera2D.h>

namespace Candera {
    FEATSTD_RTTI_DEFINITION(SolidColorBrushBlend, CombinedEffect2D)

    /******************************************************************************
     *  Constructor
     ******************************************************************************/
    SolidColorBrushBlend::SolidColorBrushBlend()
    {
    }

    SolidColorBrushBlend::SolidColorBrushBlend(const SolidColorBrushBlend& rhs) :
        Base(rhs),
        m_solidBrush(rhs.m_solidBrush),
        m_blendEffect(rhs.m_blendEffect)
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    SolidColorBrushBlend::~SolidColorBrushBlend()
    {
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    SolidColorBrushBlend::SharedPointer SolidColorBrushBlend::Create()
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

        SolidColorBrushBlend* brush = FEATSTD_NEW(SolidColorBrushBlend);
        FEATSTD_DEBUG_ASSERT(brush != 0);

        SolidColorBrushBlend::SharedPointer sharedPtr(brush);
        return sharedPtr;
    }

    /******************************************************************************
     *  Render
     ******************************************************************************/
    void SolidColorBrushBlend::Render(SurfaceHandle /*input*/, const Rectangle& /*inputArea*/, const Matrix3x2& transform,
                                           const Node2D& node, ContextHandle2D output, Rectangle& outputArea)
    {
        CANDERA_PERF_RECORDER(Timing, (FeatStd::PerfMon::TimingRecId::RenderEffect2D, "SolidColorBrushBlend"));

        const Vector2& size = m_solidBrush.Size();

        if ((size.GetX() != 0.0F) && (size.GetY() != 0.0F)) {
            m_blendEffect.ActivateBlend(output);
            m_solidBrush.ActivateColor(node, output);
            m_solidBrush.RenderSolidRectangle(transform, output, outputArea, node);
            m_solidBrush.DeactivateColor(output);
            m_blendEffect.DeactivateBlend(output);
        }
    }

    /******************************************************************************
     *  Clone
     ******************************************************************************/
    Effect2D::SharedPointer SolidColorBrushBlend::Clone() const
    {
        return Effect2D::SharedPointer(CANDERA_NEW(SolidColorBrushBlend)(*this));
    }

}   // namespace Candera
