//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ShadowBitmapBrushBlend.h"
#include <CanderaPlatform/Device/Common/Effects/ShadowEffect.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <Candera/System/Mathematics/Matrix4.h>
#include <Candera/System/Monitor/PerfMonPublicIF.h>

namespace Candera {

    FEATSTD_RTTI_DEFINITION(ShadowBitmapBrushBlend, CombinedEffect2D)

    /******************************************************************************
     *  Constructor
     ******************************************************************************/
    ShadowBitmapBrushBlend::ShadowBitmapBrushBlend()
    {
    }

    ShadowBitmapBrushBlend::ShadowBitmapBrushBlend(const ShadowBitmapBrushBlend& rhs) :
        Base(rhs),
        m_bitmapBrush(rhs.m_bitmapBrush),
        m_shadowEffect(rhs.m_shadowEffect),
        m_blendEffect(rhs.m_blendEffect)
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    ShadowBitmapBrushBlend::~ShadowBitmapBrushBlend()
    {
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    ShadowBitmapBrushBlend::SharedPointer ShadowBitmapBrushBlend::Create()
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

        ShadowBitmapBrushBlend* brush = FEATSTD_NEW(ShadowBitmapBrushBlend);
        FEATSTD_DEBUG_ASSERT(brush != 0);

        ShadowBitmapBrushBlend::SharedPointer sharedPtr(brush);
        return sharedPtr;
    }

    /******************************************************************************
     *  Render
     ******************************************************************************/
    void ShadowBitmapBrushBlend::Render(SurfaceHandle /*input*/, const Rectangle& /*inputArea*/, const Matrix3x2& transform,
                                             const Node2D& node, ContextHandle2D output, Rectangle& outputArea)
    {
        CANDERA_PERF_RECORDER(Timing, (Candera::PerfMon::TimingRecId::RenderEffect2D, "ShadowBitmapBrushBlend"));

        Image2D* image = m_bitmapBrush.Image();

        if (image != 0) {
            m_blendEffect.ActivateBlend(output);
            Rectangle rect;
            m_bitmapBrush.GetBoundingRectangle(rect);
            static_cast<void>(image->Activate(output));
            m_shadowEffect.Render(image->Get2DSurfaceHandle(), rect, transform, node, output, outputArea);
            m_blendEffect.DeactivateBlend(output);
        }
    }

    /******************************************************************************
     *  Upload
     ******************************************************************************/
    bool ShadowBitmapBrushBlend::Upload()
    {
        bool success = m_bitmapBrush.Upload();
        success = m_shadowEffect.Upload() && success;
        success = m_blendEffect.Upload() && success;
        return success;
    }
    /******************************************************************************
     *  Unload
     ******************************************************************************/
    bool ShadowBitmapBrushBlend::Unload()
    {
        bool success = m_bitmapBrush.Unload();
        success = m_shadowEffect.Unload() && success;
        success = m_blendEffect.Unload() && success;
        return success;
    }
    /******************************************************************************
     *  Update
     ******************************************************************************/
    bool ShadowBitmapBrushBlend::Update()
    {
        bool success = m_bitmapBrush.Update();
        success = m_shadowEffect.Update() && success;
        success = m_blendEffect.Update() && success;
        return success;
    }

    /******************************************************************************
     *  Clone
     ******************************************************************************/
    Effect2D::SharedPointer ShadowBitmapBrushBlend::Clone() const
    {
        return Effect2D::SharedPointer(CANDERA_NEW(ShadowBitmapBrushBlend)(*this));
    }

}   // namespace Candera
