//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlBitmapBrushMaskBlend.h"
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <Candera/System/Mathematics/Matrix3x2.h>
#include <Candera/System/Monitor/PerfMonPublicIF.h>

namespace Candera {
    FEATSTD_RTTI_DEFINITION(GlBitmapBrushMaskBlend, CombinedEffect2D)

    /******************************************************************************
     *  Constructor
     ******************************************************************************/
    GlBitmapBrushMaskBlend::GlBitmapBrushMaskBlend()
    {
    }

    GlBitmapBrushMaskBlend::GlBitmapBrushMaskBlend(const GlBitmapBrushMaskBlend& rhs) :
        Base(rhs),
        m_bitmapBrush(rhs.m_bitmapBrush),
        m_maskEffect(rhs.m_maskEffect),
        m_blendEffect(rhs.m_blendEffect)
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    GlBitmapBrushMaskBlend::~GlBitmapBrushMaskBlend()
    {
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    GlBitmapBrushMaskBlend::SharedPointer GlBitmapBrushMaskBlend::Create()
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

        GlBitmapBrushMaskBlend* brush = FEATSTD_NEW(GlBitmapBrushMaskBlend);
        FEATSTD_DEBUG_ASSERT(brush != 0);

        GlBitmapBrushMaskBlend::SharedPointer sharedPtr(brush);
        return sharedPtr;
    }

    /******************************************************************************
     *  Render
     ******************************************************************************/
    void GlBitmapBrushMaskBlend::Render(SurfaceHandle input, const Rectangle& inputArea, const Matrix3x2& transform, const Node2D& node,
                                           ContextHandle2D output, Rectangle& outputArea)
    {
        CANDERA_PERF_RECORDER(Timing, (Candera::PerfMon::TimingRecId::RenderEffect2D, "GlBitmapBrushMaskBlend"));

        if (m_bitmapBrush.Image() != 0) {
            m_blendEffect.ActivateBlend(output);
            m_maskEffect.ActivateMask(node, output);
            m_bitmapBrush.Render(input, inputArea, transform, node, output, outputArea);
            m_maskEffect.DeactivateMask(output);
            m_blendEffect.DeactivateBlend(output);
        }
    }

    /******************************************************************************
     *  Upload
     ******************************************************************************/
    bool GlBitmapBrushMaskBlend::Upload()
    {
        bool success = m_bitmapBrush.Upload();
        success = m_maskEffect.Upload() && success;
        success = m_blendEffect.Upload() && success;
        return success;
    }
    /******************************************************************************
     *  Unload
     ******************************************************************************/
    bool GlBitmapBrushMaskBlend::Unload()
    {
        bool success = m_bitmapBrush.Unload();
        success = m_maskEffect.Unload() && success;
        success = m_blendEffect.Unload() && success;
        return success;
    }
    /******************************************************************************
     *  Update
     ******************************************************************************/
    bool GlBitmapBrushMaskBlend::Update()
    {
        bool success = m_bitmapBrush.Update();
        success = m_maskEffect.Update() && success;
        success = m_blendEffect.Update() && success;
        return success;
    }

    /******************************************************************************
     *  Clone
     ******************************************************************************/
    Effect2D::SharedPointer GlBitmapBrushMaskBlend::Clone() const
    {
        return Effect2D::SharedPointer(CANDERA_NEW(GlBitmapBrushMaskBlend)(*this));
    }


}   // namespace Candera
