//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BitmapBrushBlend.h"
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <Candera/System/Monitor/PerfMonPublicIF.h>

namespace Candera {
    FEATSTD_RTTI_DEFINITION(BitmapBrushBlend, CombinedEffect2D)

    /******************************************************************************
     *  Constructor
     ******************************************************************************/
    BitmapBrushBlend::BitmapBrushBlend() :
        Base()
    {
    }

    BitmapBrushBlend::BitmapBrushBlend(const BitmapBrushBlend& rhs) :
        Base(rhs),
        m_bitmapBrush(rhs.m_bitmapBrush),
        m_blendEffect(rhs.m_blendEffect)
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    BitmapBrushBlend::~BitmapBrushBlend()
    {
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    BitmapBrushBlend::SharedPointer BitmapBrushBlend::Create()
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

        BitmapBrushBlend* brush = FEATSTD_NEW(BitmapBrushBlend);
        FEATSTD_DEBUG_ASSERT(brush != 0);

        BitmapBrushBlend::SharedPointer sharedPtr(brush);
        return sharedPtr;
    }

    /******************************************************************************
     *  Render
     ******************************************************************************/
    void BitmapBrushBlend::Render(SurfaceHandle input, const Rectangle& inputArea, const Matrix3x2& transform, const Node2D& node,
                                       ContextHandle2D output, Rectangle& outputArea)
    {
        CANDERA_PERF_RECORDER(Timing, (FeatStd::PerfMon::TimingRecId::RenderEffect2D, "BitmapBrushBlend"));

        if (m_bitmapBrush.Image() != 0) {
            m_blendEffect.ActivateBlend(output);
            m_bitmapBrush.Render(input, inputArea, transform, node, output, outputArea);
            m_blendEffect.DeactivateBlend(output);
        }
    }

    /******************************************************************************
     *  Upload
     ******************************************************************************/
    bool BitmapBrushBlend::Upload()
    {
        bool success = m_bitmapBrush.Upload();
        success = m_blendEffect.Upload() && success;
        return success;
    }
    /******************************************************************************
     *  Unload
     ******************************************************************************/
    bool BitmapBrushBlend::Unload()
    {
        bool success = m_bitmapBrush.Unload();
        success = m_blendEffect.Unload() && success;
        return success;
    }
    /******************************************************************************
     *  Update
     ******************************************************************************/
    bool BitmapBrushBlend::Update()
    {
        bool success = m_bitmapBrush.Update();
        success = m_blendEffect.Update() && success;
        return success;
    }

    /******************************************************************************
     *  Clone
     ******************************************************************************/
    Effect2D::SharedPointer BitmapBrushBlend::Clone() const
    {
        return Effect2D::SharedPointer(CANDERA_NEW(BitmapBrushBlend)(*this));
    }

}   // namespace Candera
