//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_EGLTYPEMAPPER_H)
#define CANDERA_EGLTYPEMAPPER_H

#include <CanderaTypes.h>
#include <CanderaPlatform/Device/Common/EGL/EglInclude.h>
#include <CanderaPlatform/Device/Common/EGL/EglConfiguration.h>

namespace Candera {

/** @addtogroup CommonDevice
 *  @{
 */

// Specifies an invalid parameter for render device, used for not supported Open GL ES extension tokens.
static const EGLint c_eglInvalidParameter = EGLint(-1);

const EGLenum eglColorBufferTypeValueMapping[] =
{
    EGL_RGB_BUFFER,                 // EglConfiguration::EglRgbBuffer
    EGL_LUMINANCE_BUFFER            // EglConfiguration::EglLumincanceBuffer
};

const EGLenum eglConfigCaveatValueMapping[] =
{
    EGL_NONE,                       // EglConfiguration::EglNoCaveat
    EGL_SLOW_CONFIG,                // EglConfiguration::EglSlowCaveat
    EGL_NON_CONFORMANT_CONFIG       // EglConfiguration::EglNoneConformantCaveat
};

const EGLenum eglTransparentTypeValueMapping[] =
{
    EGL_NONE,                       // EglConfiguration::EglNoTransparency
    EGL_TRANSPARENT_RGB             // EglConfiguration::EglTransparentRgb
};

const EGLenum eglConfigAttributeMapping[] =
{
    EGL_BUFFER_SIZE,                // EglConfiguration::EglBufferSize
    EGL_RED_SIZE,                   // EglConfiguration::EglRedSize
    EGL_GREEN_SIZE,                 // EglConfiguration::EglGreenSize
    EGL_BLUE_SIZE,                  // EglConfiguration::EglBlueSize
    EGL_LUMINANCE_SIZE,             // EglConfiguration::EglLuminanceSize
    EGL_ALPHA_SIZE,                 // EglConfiguration::EglAlphaSize
    EGL_ALPHA_MASK_SIZE,            // EglConfiguration::EglAlphaMaskSize
    EGL_COLOR_BUFFER_TYPE,          // EglConfiguration::EglColorBufferType
    EGL_CONFIG_CAVEAT,              // EglConfiguration::EglConfigCaveat
    EGL_CONFIG_ID,                  // EglConfiguration::EglConfigId
    EGL_CONFORMANT,                 // EglConfiguration::EglConformant
    EGL_DEPTH_SIZE,                 // EglConfiguration::EglDepthSize
    EGL_LEVEL,                      // EglConfiguration::EglLevel
    EGL_MAX_SWAP_INTERVAL,          // EglConfiguration::EglMaxSwapInterval
    EGL_MIN_SWAP_INTERVAL,          // EglConfiguration::EglMinSwapInterval
    EGL_NATIVE_RENDERABLE,          // EglConfiguration::EglNativeRenderable
    EGL_NATIVE_VISUAL_TYPE,         // EglConfiguration::EglNativeVisualType
    EGL_RENDERABLE_TYPE,            // EglConfiguration::EglRenderableType
    EGL_SAMPLE_BUFFERS,             // EglConfiguration::EglSampleBuffers
    EGL_SAMPLES,                    // EglConfiguration::EglSamples
    EGL_STENCIL_SIZE,               // EglConfiguration::EglStencilSize
    EGL_SURFACE_TYPE,               // EglConfiguration::EglSurfaceType
    EGL_TRANSPARENT_TYPE,           // EglConfiguration::EglTransparentType
    EGL_TRANSPARENT_RED_VALUE,      // EglConfiguration::EglTransparentRedValue
    EGL_TRANSPARENT_GREEN_VALUE,    // EglConfiguration::EglTransparentGreenValue
    EGL_TRANSPARENT_BLUE_VALUE,     // EglConfiguration::EglTransparentBlueValue
    EGL_DEPTH_ENCODING_NV,          // EglConfiguration::EglDepthEncoding
    EGL_COVERAGE_BUFFERS_NV,        // EglConfiguration::EglCoverageSampleBuffers
    EGL_COVERAGE_SAMPLES_NV         // EglConfiguration::EglCoverageSamples
};


// Window Surface attributes

const EGLenum renderTargetAttributeMapping[] =
{
    EGL_RENDER_BUFFER,          // EglWindowSurfaceRenderTarget::EglRenderBuffer
    EGL_VG_COLORSPACE,          // EglWindowSurfaceRenderTarget::EglVgColorSpace
    EGL_VG_ALPHA_FORMAT         // EglWindowSurfaceRenderTarget::EglVgAlphaFormat
};

const EGLenum eglRenderBufferValueMapping[] =
{
    EGL_SINGLE_BUFFER,          // EglWindowSurfaceRenderTarget::EglSingleBuffer
    EGL_BACK_BUFFER             // EglWindowSurfaceRenderTarget::EglBackBuffer
};

const EGLenum eglVgColorSpaceValueMapping[] =
{
    EGL_VG_COLORSPACE_sRGB,     // EglWindowSurfaceRenderTarget::EglVgColorspaceSRgb
    EGL_VG_COLORSPACE_LINEAR    // EglWindowSurfaceRenderTarget::EglVgColorspaceLinear
};

const EGLenum eglVgAlphaFormatValueMapping[] =
{
    EGL_VG_ALPHA_FORMAT_NONPRE, // EglWindowSurfaceRenderTarget::EglVgAlphaFormatNonpre
    EGL_VG_ALPHA_FORMAT_PRE     // EglWindowSurfaceRenderTarget::EglVgAlphaFormatPre
};

// Context attributes

const EGLenum contextAttributeMapping [] =
{
    EGL_CONTEXT_CLIENT_VERSION  // EglContext::EglContextClientVersion
};


/**
 * @brief The EglTypeMapper is a helper class used by EglRenderDevice to map Candera types to EGL types.
 */
class EglTypeMapper
{
    private:

        // EglWindowSurfaceRenderTarget - attributes - enums
        static EGLint MapEglRenderBufferEnum(Int32 value) { return eglRenderBufferValueMapping[value]; }
        static EGLint MapEglVgColorSpaceEnum(Int32 value) { return eglVgColorSpaceValueMapping[value]; }
        static EGLint MapEglVgAlphaFormatEnum(Int32 value) { return eglVgAlphaFormatValueMapping[value]; }

        // EglWindowSurfaceRenderTarget - configuration - bitmasks
        static EGLint MapEglConformantBitmask(Int32 value);
        static EGLint MapEglRenderableTypeBitmask(Int32 value);
        static EGLint MapEglSurfaceTypeBitmask(Int32 value);

        // EglWindowSurfaceRenderTarget - configuration - enums
        static EGLint MapEglColorBufferTypeEnum(Int32 value) { return eglColorBufferTypeValueMapping[value]; }
        static EGLint MapEglConfigCaveatEnum(Int32 value) { return eglConfigCaveatValueMapping[value]; }
        static EGLint MapEglTransparentTypeEnum(Int32 value) { return eglTransparentTypeValueMapping[value]; }

        // EglWindowSorfaceRenderTarget - extensions - enums
        static EGLint MapEglDepthEncodingEnum(Int32 value);
        // general
        static EGLint MapEglInteger(Int32 value);
        static EGLint MapEglBoolean(Int32 value);

    public:
        
        static const Int c_maxEglConfigSize = static_cast<Int>(EglConfiguration::EglNumberOfConfigAttributes) * 2 + 1;
        static void MapEglConfiguration(EGLint* eglConfig, const Int32* const config);
};
    /** @}*/ //end of CommonDevice
} // namespace Candera

#endif// CANDERA_EGLTYPEMAPPER_H
